/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cmd.AbstractDeleteProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeleteProcessDefinitionsByIdsCmd
extends AbstractDeleteProcessDefinitionCmd {
    private final List<String> processDefinitionIds;
    private final String tenantId;

    public DeleteProcessDefinitionsByIdsCmd(List<String> processDefinitionIds, boolean cascade, boolean skipCustomListeners, String tenantId) {
        this.processDefinitionIds = processDefinitionIds;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
        this.tenantId = tenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processDefinitionIds", this.processDefinitionIds);
        List<ProcessDefinition> processDefinitions = commandContext.getProcessDefinitionManager().findDefinitionsByIdsAndTenantId(this.processDefinitionIds, this.tenantId);
        EnsureUtil.ensureNotEmpty(NotFoundException.class, "No process definition found", "processDefinitions", processDefinitions);
        for (ProcessDefinition processDefinition : processDefinitions) {
            String processDefinitionId = processDefinition.getId();
            this.deleteProcessDefinitionCmd(commandContext, processDefinitionId, this.cascade, this.skipCustomListeners);
        }
        return null;
    }
}

