/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn.query.history;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricCaseInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deployment(new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey("oneTaskCase").caseDefinitionWithoutTenantId().create();
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    public void testQueryNoTenantIdSet() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByInstancesWithoutTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricCaseInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicCaseInstances = ((HistoricCaseInstanceQuery)this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicCaseInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricCaseInstance)historicCaseInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricCaseInstance)historicCaseInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicCaseInstances = ((HistoricCaseInstanceQuery)this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicCaseInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricCaseInstance)historicCaseInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricCaseInstance)historicCaseInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected void createCaseInstance(String tenantId) {
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("oneTaskCase");
        builder.caseDefinitionTenantId(tenantId).create();
    }
}

