/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.util.IncrementCounterListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RuntimeServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    private int defaultBatchJobsPerSeed;
    private int defaultInvocationsPerBatchJob;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public RuleChain migrationChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.migrationRule);

    @Override
    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Before
    public void storeEngineSettings() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = configuration.getInvocationsPerBatchJob();
    }

    @After
    public void restoreEngineSettings() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithList() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithListOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNonExistingId() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        processIds.add("unknown");
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete");
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Exception e = exceptions.get(0);
        Assert.assertTrue((boolean)e.getMessage().startsWith("No process instance found for id 'unknown'"));
        Assert.assertThat((Object)this.managementService.createJobQuery().withException().list().size(), (Matcher)CoreMatchers.is((Object)1));
        processIds.remove("unknown");
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithEmptyList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(new ArrayList(), null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQuery() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceQuery, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryWithoutDeleteReason() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, null);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "deleted", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullQueryParameter() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithInvalidQueryParameter() throws Exception {
        this.startTestProcesses(2);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("invalid");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, query, "testing instance delete");
    }

    protected void assertProcessInstancesAreDeleted() {
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().list().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testDeleteProcessInstancesAsyncWithSkipCustomListeners() {
        IncrementCounterListener.counter = 0;
        BpmnModelInstance instance = ((UserTaskBuilder)ProcessModels.newModel("oneTaskProcess").startEvent().userTask().camundaExecutionListenerClass("end", IncrementCounterListener.class.getName())).endEvent().done();
        this.testRule.deploy(instance);
        List<String> processIds = this.startTestProcesses(1);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete", true);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        Assert.assertThat((Object)IncrementCounterListener.counter, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testDeleteProcessInstancesAsyncWithSkipSubprocesses() {
        BpmnModelInstance callingInstance = ((CallActivityBuilder)ProcessModels.newModel("oneTaskProcess").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledInstance = ProcessModels.newModel("called").startEvent().userTask().endEvent().done();
        this.testRule.deploy(callingInstance, calledInstance);
        List<String> processIds = this.startTestProcesses(1);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete", false, true);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        ProcessInstance superInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processIds.get(0)).singleResult();
        Assert.assertNull((Object)superInstance);
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("called").singleResult();
        Assert.assertNotNull((Object)subInstance);
    }

    @Test
    public void testDeleteProcessInstancesAsyncWithoutSkipSubprocesses() {
        BpmnModelInstance callingInstance = ((CallActivityBuilder)ProcessModels.newModel("oneTaskProcess").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledInstance = ProcessModels.newModel("called").startEvent().userTask().endEvent().done();
        this.testRule.deploy(callingInstance, calledInstance);
        List<String> processIds = this.startTestProcesses(1);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete", false, false);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        ProcessInstance superInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processIds.get(0)).singleResult();
        Assert.assertNull((Object)superInstance);
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("called").singleResult();
        Assert.assertNull((Object)subInstance);
    }

    @Test
    public void testInvokeListenersWhenDeletingProcessInstancesAsync() {
        IncrementCounterListener.counter = 0;
        BpmnModelInstance instance = ((UserTaskBuilder)ProcessModels.newModel("oneTaskProcess").startEvent().userTask().camundaExecutionListenerClass("end", IncrementCounterListener.class.getName())).endEvent().done();
        this.migrationRule.deploy(instance);
        List<String> processIds = this.startTestProcesses(1);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        Assert.assertThat((Object)IncrementCounterListener.counter, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testDeleteProcessInstancesAsyncWithListInDifferentDeployments() {
        ProcessDefinition sourceDefinition1 = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "ONE_TASK_PROCESS"));
        ProcessDefinition sourceDefinition2 = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).changeElementId("Process", "TWO_TASKS_PROCESS"));
        List<String> processInstanceIds = this.createProcessInstances(sourceDefinition1, sourceDefinition2, 15, 10);
        String firstDeploymentId = sourceDefinition1.getDeploymentId();
        String secondDeploymentId = sourceDefinition2.getDeploymentId();
        List<String> processInstanceIdsFromFirstDeployment = this.getProcessInstanceIdsByDeploymentId(firstDeploymentId);
        List<String> processInstanceIdsFromSecondDeployment = this.getProcessInstanceIdsByDeploymentId(secondDeploymentId);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(3);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceIds, null, "test_reason");
        String seedJobDefinitionId = batch.getSeedJobDefinitionId();
        int expectedSeedJobsCount = 5;
        this.createAndExecuteSeedJobs(seedJobDefinitionId, expectedSeedJobsCount);
        List jobs = this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
        List<String> jobIdsForFirstDeployment = this.getJobIdsByDeployment(jobs, firstDeploymentId);
        Assert.assertNotNull(jobIdsForFirstDeployment);
        for (String jobId : jobIdsForFirstDeployment) {
            this.managementService.executeJob(jobId);
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().deploymentId(firstDeploymentId).count());
        this.assertHistoricTaskDeletionPresent(processInstanceIdsFromFirstDeployment, "test_reason", this.testRule);
        Assert.assertEquals((long)processInstanceIdsFromSecondDeployment.size(), (long)this.runtimeService.createProcessInstanceQuery().deploymentId(secondDeploymentId).count());
        this.assertHistoricTaskDeletionPresent(processInstanceIdsFromSecondDeployment, null, this.testRule);
        List<String> jobIdsForSecondDeployment = this.getJobIdsByDeployment(jobs, secondDeploymentId);
        Assert.assertNotNull(jobIdsForSecondDeployment);
        for (String jobId : jobIdsForSecondDeployment) {
            this.managementService.executeJob(jobId);
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    private List<String> createProcessInstances(ProcessDefinition sourceDefinition1, ProcessDefinition sourceDefinition2, int instanceCountDef1, int instanceCountDef2) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCountDef1; ++i) {
            ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(sourceDefinition1.getId());
            processInstanceIds.add(processInstance1.getId());
            if (i >= instanceCountDef2) continue;
            ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceById(sourceDefinition2.getId());
            processInstanceIds.add(processInstance2.getId());
        }
        return processInstanceIds;
    }

    private List<String> getProcessInstanceIdsByDeploymentId(String deploymentId) {
        List processInstances = this.runtimeService.createProcessInstanceQuery().deploymentId(deploymentId).list();
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (ProcessInstance processInstance : processInstances) {
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }

    private List<String> getJobIdsByDeployment(List<Job> jobs, String deploymentId) {
        LinkedList<String> jobIdsForDeployment = new LinkedList<String>();
        for (int i = 0; i < jobs.size(); ++i) {
            if (!jobs.get(i).getDeploymentId().equals(deploymentId)) continue;
            jobIdsForDeployment.add(jobs.get(i).getId());
        }
        return jobIdsForDeployment;
    }

    private void createAndExecuteSeedJobs(String seedJobDefinitionId, int expectedSeedJobsCount) {
        for (int i = 0; i <= expectedSeedJobsCount; ++i) {
            Job seedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(seedJobDefinitionId).singleResult();
            if (i != expectedSeedJobsCount) {
                Assert.assertNotNull((Object)seedJob);
                this.managementService.executeJob(seedJob.getId());
                continue;
            }
            Assert.assertNull((Object)seedJob);
        }
    }
}

