/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;

public class MessageIntermediateEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSingleIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        String messageName = "newInvoiceMessage";
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived(messageName, execution.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment
    public void testConcurrentIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)2, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch1"));
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch2"));
        String messageName = "newInvoiceMessage";
        List executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).list();
        MessageIntermediateEventTest.assertNotNull((Object)executions);
        MessageIntermediateEventTest.assertEquals((int)2, (int)executions.size());
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(0)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNull((Object)task);
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(1)).getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    public void testIntermediateMessageEventRedeployment() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        MessageIntermediateEventTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        MessageIntermediateEventTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            MessageIntermediateEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageIntermediateEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml"})
    public void testSetSerializedVariableValues() throws IOException, ClassNotFoundException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        EventSubscription messageEventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.processEngine);
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.messageEventReceived("newInvoiceMessage", messageEventSubscription.getExecutionId(), (Map)Variables.createVariables().putValueTyped("var", Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()));
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(processInstance.getId(), "var", false);
        MessageIntermediateEventTest.assertNotNull((Object)variableTyped);
        MessageIntermediateEventTest.assertFalse((boolean)variableTyped.isDeserialized());
        MessageIntermediateEventTest.assertEquals((String)serializedObject, (String)variableTyped.getValueSerialized());
        MessageIntermediateEventTest.assertEquals((String)FailingJavaSerializable.class.getName(), (String)variableTyped.getObjectTypeName());
        MessageIntermediateEventTest.assertEquals((String)Variables.SerializationDataFormats.JAVA.getName(), (String)variableTyped.getSerializationDataFormat());
    }

    @Deployment
    public void testExpressionInSingleIntermediateMessageEvent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", variables);
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        String messageName = "newInvoiceMessage-bar";
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived(messageName, execution.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }
}

