/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.exclusive;

import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class ExclusiveCatchEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testNonExclusiveCatchEvent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveCatchEventTest.assertNotNull((Object)job);
        ExclusiveCatchEventTest.assertFalse((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveCatchEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveCatchEvent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveCatchEventTest.assertNotNull((Object)job);
        ExclusiveCatchEventTest.assertTrue((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveCatchEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveCatchEventConcurrent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        ExclusiveCatchEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveCatchEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }
}

