/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricDetailQueryTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected TaskService taskService;
    private IdentityService identityService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        this.identityService.setAuthenticatedUserId("demo");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String userOperationId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getUserOperationId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId(userOperationId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.userOperationId(null);
            Assert.fail((String)"It was possible to set a null value as userOperationId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String executionId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getExecutionId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId(executionId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue");
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1);
    }

    protected void startProcessInstances(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.testHelper.executeAvailableJobs();
    }
}

