/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BatchCreationAuthorizationTest {
    protected static final String TEST_REASON = "test reason";
    protected static final String JOB_EXCEPTION_DEFINITION_XML = "org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected ProcessInstance processInstance;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void deployProcesses() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testBatchProcessInstanceDeletion() {
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        List<String> processInstanceIds = Collections.singletonList(this.processInstance.getId());
        this.runtimeService.deleteProcessInstancesAsync(processInstanceIds, null, TEST_REASON);
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void createBatchModification() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process1").startEvent().userTask("user1").userTask("user2").endEvent().done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        ArrayList<String> instances = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process1");
            instances.add(processInstance.getId());
        }
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        ((ModificationBuilder)this.engineRule.getRuntimeService().createModification(processDefinition.getId()).startAfterActivity("user1")).processInstanceIds(instances).executeAsync();
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void testBatchSetJobRetriesByJobs() {
        List<String> jobIds = this.setupFailedJobs();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        this.managementService.setJobRetriesAsync(jobIds, 5);
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void testBatchSetJobRetriesByProcesses() {
        this.setupFailedJobs();
        List<String> processInstanceIds = Collections.singletonList(this.processInstance.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        this.managementService.setJobRetriesAsync(processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.authRule.assertScenario(this.scenario);
    }

    protected List<String> setupFailedJobs() {
        ArrayList<String> jobIds = new ArrayList<String>();
        DeploymentWithDefinitions deploy = this.testHelper.deploy(JOB_EXCEPTION_DEFINITION_XML);
        ProcessDefinition sourceDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deploy.getId()).singleResult();
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        List jobs = this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).list();
        for (Job job : jobs) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testBatchHistoricProcessInstanceDeletion() {
        List<String> historicProcessInstances = this.setupHistory();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        this.historyService.deleteHistoricProcessInstancesAsync(historicProcessInstances, TEST_REASON);
        this.authRule.assertScenario(this.scenario);
    }

    protected List<String> setupHistory() {
        this.runtimeService.deleteProcessInstance(this.processInstance.getId(), null);
        ArrayList<String> historicProcessInstances = new ArrayList<String>();
        for (HistoricProcessInstance hpi : this.historyService.createHistoricProcessInstanceQuery().list()) {
            historicProcessInstances.add(hpi.getId());
        }
        return historicProcessInstances;
    }
}

