/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    @Test
    public void testDeploymentStatisticsQuery() {
        String deploymentName = "my deployment";
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").name(deploymentName).deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        Assert.assertEquals((Object)deployment.getId(), (Object)result.getId());
        Assert.assertEquals((Object)deploymentName, (Object)result.getName());
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(deployment.getDeploymentTime());
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(result.getDeploymentTime());
        cal2.set(14, 0);
        Assert.assertTrue((boolean)cal1.equals(cal2));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testDeploymentStatisticsQueryCountAndPaging() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        org.camunda.bpm.engine.repository.Deployment anotherDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        long count = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().count();
        Assert.assertEquals((long)2L, (long)count);
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.repositoryService.deleteDeployment(anotherDeployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidents() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().list();
        DeploymentStatisticsQueryTest.assertFalse((boolean)statistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("failedJob").list();
        DeploymentStatisticsQueryTest.assertFalse((boolean)statistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithInvalidIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("invalid").list();
        DeploymentStatisticsQueryTest.assertFalse((boolean)statistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertTrue((boolean)incidentStatistics.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidentsAndFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().includeFailedJobs().list();
        DeploymentStatisticsQueryTest.assertFalse((boolean)statistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithTwoIncidentsAndOneFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().includeFailedJobs().list();
        DeploymentStatisticsQueryTest.assertFalse((boolean)statistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        DeploymentStatisticsQueryTest.assertEquals((int)2, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithoutRunningInstances() {
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentsWithFailedTimerStartEvent() {
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().list();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)0, (int)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistic.getIncidentCount());
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentTypeWithFailedTimerStartEvent() {
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("failedJob").list();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)0, (int)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistic.getIncidentCount());
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsWithFailedTimerStartEvent() {
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)0, (int)result.getInstances());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)result.getFailedJobs());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsAndIncidentsWithFailedTimerStartEvent() {
        this.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents().list();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)0, (int)result.getInstances());
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        DeploymentStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistic.getIncidentCount());
        DeploymentStatisticsQueryTest.assertEquals((String)"failedJob", (String)incidentStatistic.getIncidentType());
    }
}

