/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartQueryImpl;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.cmmn.VariableTransition;

public class SentryInitializationTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testOnPart.cmmn"})
    public void testOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        SentryInitializationTest.assertEquals((int)1, (int)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"planItemOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)"PI_HumanTask_1", (String)part.getSource());
        SentryInitializationTest.assertEquals((String)"complete", (String)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testVariableOnPart.cmmn"})
    public void testVariableOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        SentryInitializationTest.assertEquals((int)1, (int)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"variableOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)VariableTransition.create.name(), (String)part.getVariableEvent());
        SentryInitializationTest.assertEquals((String)"variable_1", (String)part.getVariableName());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testIfPart.cmmn"})
    public void testIfPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        SentryInitializationTest.assertEquals((int)1, (int)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"ifPart", (String)part.getType());
        SentryInitializationTest.assertNull((Object)part.getSource());
        SentryInitializationTest.assertNull((Object)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testOnPartIfPartAndVariableOnPart.cmmn"})
    public void testOnPartIfPartAndVariableOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        SentryInitializationTest.assertEquals((long)3L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.type("ifPart").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"ifPart", (String)part.getType());
        SentryInitializationTest.assertNull((Object)part.getSource());
        SentryInitializationTest.assertNull((Object)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.type("planItemOnPart").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"planItemOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)"PI_HumanTask_1", (String)part.getSource());
        SentryInitializationTest.assertEquals((String)"complete", (String)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.type("variableOnPart").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"variableOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)VariableTransition.delete.name(), (String)part.getVariableEvent());
        SentryInitializationTest.assertEquals((String)"variable_1", (String)part.getVariableName());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testMultipleSentries.cmmn"})
    public void testMultipleSentries() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        SentryInitializationTest.assertEquals((long)2L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.sentryId("Sentry_1").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"ifPart", (String)part.getType());
        SentryInitializationTest.assertNull((Object)part.getSource());
        SentryInitializationTest.assertNull((Object)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.sentryId("Sentry_2").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)"Sentry_2", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"planItemOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)"PI_HumanTask_1", (String)part.getSource());
        SentryInitializationTest.assertEquals((String)"complete", (String)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testMultipleSentriesWithinStage.cmmn"})
    public void testMultipleSentriesWithinStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        SentryInitializationTest.assertEquals((long)2L, (long)query.count());
        String stageId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        SentryInitializationTest.assertEquals((long)2L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.sentryId("Sentry_1").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)stageId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)"Sentry_1", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"ifPart", (String)part.getType());
        SentryInitializationTest.assertNull((Object)part.getSource());
        SentryInitializationTest.assertNull((Object)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.sentryId("Sentry_2").singleResult();
        SentryInitializationTest.assertEquals((String)caseInstanceId, (String)part.getCaseInstanceId());
        SentryInitializationTest.assertEquals((String)stageId, (String)part.getCaseExecutionId());
        SentryInitializationTest.assertEquals((String)"Sentry_2", (String)part.getSentryId());
        SentryInitializationTest.assertEquals((String)"planItemOnPart", (String)part.getType());
        SentryInitializationTest.assertEquals((String)"PI_HumanTask_1", (String)part.getSource());
        SentryInitializationTest.assertEquals((String)"complete", (String)part.getStandardEvent());
        SentryInitializationTest.assertFalse((boolean)part.isSatisfied());
    }
}

