/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class CleanableHistoricCaseInstanceReportTest {
    private static final String FORTH_CASE_DEFINITION_KEY = "case";
    private static final String THIRD_CASE_DEFINITION_KEY = "oneTaskCase";
    private static final String SECOND_CASE_DEFINITION_KEY = "oneCaseTaskCase";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected CaseService caseService;
    protected TaskService taskService;
    protected static final String CASE_DEFINITION_KEY = "one";

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.caseService = this.engineRule.getCaseService();
        this.taskService = this.engineRule.getTaskService();
        this.testRule.deploy("org/camunda/bpm/engine/test/repository/one.cmmn");
    }

    @After
    public void cleanUp() {
        List instanceList = this.historyService.createHistoricCaseInstanceQuery().active().list();
        if (!instanceList.isEmpty()) {
            for (HistoricCaseInstance instance : instanceList) {
                this.caseService.terminateCaseExecution(instance.getId());
                this.caseService.closeCaseInstance(instance.getId());
            }
        }
        List historicCaseInstances = this.historyService.createHistoricCaseInstanceQuery().list();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            this.historyService.deleteHistoricCaseInstance(historicCaseInstance.getId());
        }
    }

    private void prepareCaseInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key);
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void checkResultNumbers(CleanableHistoricCaseInstanceReportResult result, int expectedCleanable, int expectedFinished) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableCaseInstanceCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedCaseInstanceCount());
    }

    @Test
    public void testReportWithAllCleanableInstances() {
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        long count = this.historyService.createCleanableHistoricCaseInstanceReport().count();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)1L, (long)count);
        this.checkResultNumbers((CleanableHistoricCaseInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithPartiallyCleanableInstances() {
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 5);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, 0, 5, 5);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricCaseInstanceReportResult)reportResults.get(0), 5, 10);
    }

    @Test
    public void testReportWithZeroHistoryTTL() {
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 0, 5);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, 0, 0, 5);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricCaseInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithNullHistoryTTL() {
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, null, 5);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, 0, null, 5);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricCaseInstanceReportResult)reportResults.get(0), 0, 10);
    }

    @Test
    public void testReportComplex() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn");
        this.prepareCaseInstances(CASE_DEFINITION_KEY, 0, 5, 10);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10);
        this.prepareCaseInstances(SECOND_CASE_DEFINITION_KEY, -6, null, 10);
        this.prepareCaseInstances(THIRD_CASE_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        String id = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(SECOND_CASE_DEFINITION_KEY).singleResult()).getId();
        CleanableHistoricCaseInstanceReportResult secondReportResult = (CleanableHistoricCaseInstanceReportResult)this.historyService.createCleanableHistoricCaseInstanceReport().caseDefinitionIdIn(new String[]{id}).singleResult();
        CleanableHistoricCaseInstanceReportResult thirdReportResult = (CleanableHistoricCaseInstanceReportResult)this.historyService.createCleanableHistoricCaseInstanceReport().caseDefinitionKeyIn(new String[]{THIRD_CASE_DEFINITION_KEY}).singleResult();
        Assert.assertEquals((long)4L, (long)reportResults.size());
        for (CleanableHistoricCaseInstanceReportResult result : reportResults) {
            if (result.getCaseDefinitionKey().equals(CASE_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 20);
                continue;
            }
            if (result.getCaseDefinitionKey().equals(SECOND_CASE_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 0, 10);
                continue;
            }
            if (result.getCaseDefinitionKey().equals(THIRD_CASE_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 10);
                continue;
            }
            if (!result.getCaseDefinitionKey().equals(FORTH_CASE_DEFINITION_KEY)) continue;
            this.checkResultNumbers(result, 0, 0);
        }
        this.checkResultNumbers(secondReportResult, 0, 10);
        this.checkResultNumbers(thirdReportResult, 10, 10);
    }

    @Test
    public void testReportByInvalidCaseDefinitionId() {
        CleanableHistoricCaseInstanceReport report = this.historyService.createCleanableHistoricCaseInstanceReport();
        try {
            report.caseDefinitionIdIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            report.caseDefinitionIdIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByInvalidCaseDefinitionKey() {
        CleanableHistoricCaseInstanceReport report = this.historyService.createCleanableHistoricCaseInstanceReport();
        try {
            report.caseDefinitionKeyIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            report.caseDefinitionKeyIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportCompact() {
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        List resultWithZeros = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)resultWithZeros.size());
        Assert.assertEquals((long)0L, (long)((CleanableHistoricCaseInstanceReportResult)resultWithZeros.get(0)).getFinishedCaseInstanceCount());
        long resultCountWithoutZeros = this.historyService.createCleanableHistoricCaseInstanceReport().compact().count();
        Assert.assertEquals((long)0L, (long)resultCountWithoutZeros);
    }

    @Test
    public void testReportOrderByFinishedAsc() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
        this.prepareCaseInstances(THIRD_CASE_DEFINITION_KEY, -6, 5, 8);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 4);
        this.prepareCaseInstances(SECOND_CASE_DEFINITION_KEY, -6, 5, 6);
        List reportResult = ((CleanableHistoricCaseInstanceReport)this.historyService.createCleanableHistoricCaseInstanceReport().orderByFinished().asc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(0)).getCaseDefinitionKey());
        Assert.assertEquals((Object)SECOND_CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(1)).getCaseDefinitionKey());
        Assert.assertEquals((Object)THIRD_CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(2)).getCaseDefinitionKey());
    }

    @Test
    public void testReportOrderByFinishedDesc() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
        this.prepareCaseInstances(THIRD_CASE_DEFINITION_KEY, -6, 5, 8);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 4);
        this.prepareCaseInstances(SECOND_CASE_DEFINITION_KEY, -6, 5, 6);
        List reportResult = ((CleanableHistoricCaseInstanceReport)this.historyService.createCleanableHistoricCaseInstanceReport().orderByFinished().desc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)THIRD_CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(0)).getCaseDefinitionKey());
        Assert.assertEquals((Object)SECOND_CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(1)).getCaseDefinitionKey());
        Assert.assertEquals((Object)CASE_DEFINITION_KEY, (Object)((CleanableHistoricCaseInstanceReportResult)reportResult.get(2)).getCaseDefinitionKey());
    }
}

