/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Arrays;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class AuditHistoryTest
extends ResourceProcessEngineTestCase {
    public AuditHistoryTest() {
        super("org/camunda/bpm/engine/test/standalone/history/audithistory.camunda.cfg.xml");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testReceivesNoHistoricVariableUpdatesAsDetails() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String value = "a Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)value);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)value.getBytes());
        String newValue = "a new Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)newValue);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)newValue.getBytes());
        AuditHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstance historicStringVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aStringVariable").singleResult();
        AuditHistoryTest.assertNotNull((Object)historicStringVariable);
        AuditHistoryTest.assertEquals((Object)newValue, (Object)historicStringVariable.getValue());
        HistoricVariableInstance historicBytesVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aBytesVariable").singleResult();
        AuditHistoryTest.assertNotNull((Object)historicBytesVariable);
        AuditHistoryTest.assertTrue((boolean)Arrays.equals(newValue.getBytes(), (byte[])historicBytesVariable.getValue()));
        AuditHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().count());
    }
}

