/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MessageReceiveModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationMessageStartEventTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    protected RuntimeService runtimeService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Before
    public void setup() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    public void testMigrateEventSubscription() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.MESSAGE_START_PROCESS);
        String sourceProcessDefinitionId = sourceProcessDefinition.getId();
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinitionId, sourceProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinitionId);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().activityId("startEvent").eventName("Message").singleResult();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        this.assertEventSubscriptionMigrated(eventSubscription, "startEvent", "Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionWithEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        EventSubscription eventSubscriptionAfter = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)eventSubscriptionAfter);
        Assert.assertEquals((Object)"Message", (Object)eventSubscriptionAfter.getEventName());
        this.runtimeService.correlateMessage("Message");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    protected void assertEventSubscriptionMigrated(EventSubscription eventSubscriptionBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionAfter = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((String)("Expected that an event subscription with id '" + eventSubscriptionBefore.getId() + "' " + "exists after migration"), (Object)eventSubscriptionAfter);
        Assert.assertEquals((Object)eventSubscriptionBefore.getEventType(), (Object)eventSubscriptionAfter.getEventType());
        Assert.assertEquals((Object)activityIdAfter, (Object)eventSubscriptionAfter.getActivityId());
        Assert.assertEquals((Object)eventName, (Object)eventSubscriptionAfter.getEventName());
    }
}

