/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Arrays;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class CustomHistoryTest
extends ResourceProcessEngineTestCase {
    public CustomHistoryTest() {
        super("org/camunda/bpm/engine/test/standalone/history/customhistory.camunda.cfg.xml");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testReceivesVariableUpdates() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String value = "a Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)value);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)value.getBytes());
        CustomHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstance historicStringVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aStringVariable").singleResult();
        CustomHistoryTest.assertNotNull((Object)historicStringVariable);
        CustomHistoryTest.assertEquals((Object)value, (Object)historicStringVariable.getValue());
        HistoricVariableInstance historicBytesVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aBytesVariable").singleResult();
        CustomHistoryTest.assertNotNull((Object)historicBytesVariable);
        CustomHistoryTest.assertTrue((boolean)Arrays.equals(value.getBytes(), (byte[])historicBytesVariable.getValue()));
        CustomHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().count());
        HistoricVariableUpdate historicStringVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicStringVariable.getId()).singleResult();
        CustomHistoryTest.assertNotNull((Object)historicStringVariableUpdate);
        CustomHistoryTest.assertEquals((Object)value, (Object)historicStringVariableUpdate.getValue());
        HistoricVariableUpdate historicByteVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicBytesVariable.getId()).singleResult();
        CustomHistoryTest.assertNotNull((Object)historicByteVariableUpdate);
        CustomHistoryTest.assertTrue((boolean)Arrays.equals(value.getBytes(), (byte[])historicByteVariableUpdate.getValue()));
    }
}

