/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class HistoryCleanupOnEngineStartTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setHistoryCleanupBatchWindowStartTime("23:00");
            configuration.setHistoryCleanupBatchWindowEndTime("01:00");
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private HistoryService historyService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.historyService = this.engineRule.getProcessEngine().getHistoryService();
    }

    @After
    public void clearDatabase() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupOnEngineStartTest.this.engineRule.getProcessEngine().getManagementService().createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
    }

    @Test
    public void testHistoryCleanupJob() throws ParseException {
        Job historyCleanupJob = this.historyService.findHistoryCleanupJob();
        Assert.assertNotNull((Object)historyCleanupJob);
        Date historyCleanupBatchWindowStartTime = ((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getHistoryCleanupBatchWindowStartTimeAsDate();
        Date historyCleanupBatchWindowEndTime = ((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getHistoryCleanupBatchWindowEndTimeAsDate();
        Assert.assertEquals((Object)HistoryCleanupHelper.getCurrentOrNextBatchWindowStartTime((Date)ClockUtil.getCurrentTime(), (Date)historyCleanupBatchWindowStartTime, (Date)HistoryCleanupHelper.addDays((Date)historyCleanupBatchWindowEndTime, (int)1)), (Object)historyCleanupJob.getDuedate());
    }
}

