/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.Deployment;

public class JobDefinitionPriorityTest
extends PluggableProcessEngineTestCase {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 0L;

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)42L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)job.getPriority(), (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        JobDefinitionPriorityTest.assertEquals((long)42L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriorityWithCascade() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 52L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)52L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)52L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        JobDefinitionPriorityTest.assertEquals((long)52L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriorityOverridesBpmnPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 62L);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)62L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)5L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task2")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        JobDefinitionPriorityTest.assertEquals((long)62L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriorityWithCascadeOverridesBpmnPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 72L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)72L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)72L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task2")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        JobDefinitionPriorityTest.assertEquals((long)72L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    public void testRedeployOverridesSetJobDefinitionPriority() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 72L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)72L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)72L, (long)updatedExistingJob.getPriority());
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml").deploy().getId();
        ProcessInstance secondInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job newJob = (Job)this.managementService.createJobQuery().processInstanceId(secondInstance.getId()).singleResult();
        JobDefinitionPriorityTest.assertEquals((long)5L, (long)newJob.getPriority());
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testResetJobDefinitionPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertNull((Object)updatedDefinition.getOverridingJobPriority());
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testResetJobDefinitionPriorityWhenPriorityIsNull() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobDefinitionPriorityTest.assertNull((Object)jobDefinition.getOverridingJobPriority());
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        JobDefinitionPriorityTest.assertNull((Object)updatedDefinition.getOverridingJobPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    public void testGetJobDefinitionDefaultPriority() {
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        JobDefinitionPriorityTest.assertEquals((int)4, (int)jobDefinitions.size());
        JobDefinitionPriorityTest.assertNull((Object)((JobDefinition)jobDefinitions.get(0)).getOverridingJobPriority());
        JobDefinitionPriorityTest.assertNull((Object)((JobDefinition)jobDefinitions.get(1)).getOverridingJobPriority());
        JobDefinitionPriorityTest.assertNull((Object)((JobDefinition)jobDefinitions.get(2)).getOverridingJobPriority());
        JobDefinitionPriorityTest.assertNull((Object)((JobDefinition)jobDefinitions.get(3)).getOverridingJobPriority());
    }

    public void testSetNonExistingJobDefinitionPriority() {
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId", 42L);
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId", 42L, true);
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
    }

    public void testResetNonExistingJobDefinitionPriority() {
        try {
            this.managementService.clearOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId");
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
    }

    public void testSetNullJobDefinitionPriority() {
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition(null, 42L);
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition(null, 42L, true);
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
    }

    public void testResetNullJobDefinitionPriority() {
        try {
            this.managementService.clearOverridingJobPriorityForJobDefinition(null);
            JobDefinitionPriorityTest.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriorityToExtremeValues() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), Long.MAX_VALUE);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)Long.MAX_VALUE, (long)jobDefinition.getOverridingJobPriority());
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), -9223372036854775807L);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobDefinitionPriorityTest.assertEquals((long)-9223372036854775807L, (long)jobDefinition.getOverridingJobPriority());
    }

    protected Job getJobThatIsNot(Job other) {
        List jobs = this.managementService.createJobQuery().list();
        JobDefinitionPriorityTest.assertEquals((int)2, (int)jobs.size());
        if (((Job)jobs.get(0)).getId().equals(other.getId())) {
            return (Job)jobs.get(1);
        }
        if (((Job)jobs.get(1)).getId().equals(other.getId())) {
            return (Job)jobs.get(0);
        }
        throw new ProcessEngineException("Job with id " + other.getId() + " does not exist anymore");
    }
}

