/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import java.util.Arrays;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyCreateCaseInstanceTest
extends PluggableProcessEngineTestCase {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CASE_DEFINITION_KEY = "oneTaskCase";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    public void testFailToCreateCaseInstanceByIdWithoutTenantId() {
        this.deployment(new String[]{CMMN_FILE});
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionWithoutTenantId().create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToCreateCaseInstanceByIdWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionTenantId(TENANT_ONE).create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToCreateCaseInstanceByKeyForNonExistingTenantID() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId("nonExistingTenantId").create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'oneTaskCase' and tenant-id 'nonExistingTenantId'"));
        }
    }

    public void testFailToCreateCaseInstanceByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants."));
        }
    }

    public void testCreateCaseInstanceByKeyWithoutTenantId() {
        this.deployment(new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((CaseInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testCreateCaseInstanceByKeyForAnyTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        Assert.assertThat((Object)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCreateCaseInstanceByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        Assert.assertThat((Object)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCreateCaseInstanceByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deployment(new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToCreateCaseInstanceByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'oneTaskCase'"));
        }
    }

    public void testFailToCreateCaseInstanceByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the case definition"));
        }
    }

    public void testFailToCreateCaseInstanceByIdNoAuthenticatedTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).create();
            MultiTenancyCreateCaseInstanceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the case definition"));
        }
    }

    public void testCreateCaseInstanceByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCreateCaseInstanceByIdAuthenticatedTenant() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCreateCaseInstanceByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testCreateCaseInstanceByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

