/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyStartProcessInstanceByConditionCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance PROCESS = ((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionStart").startEvent().conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNoAuthenticatedTenants() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.ensureEventSubscriptions(3);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List instances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.engineRule.getIdentityService().clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.withoutTenantId().count());
    }

    @Test
    public void testWithAuthenticatedTenant() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.ensureEventSubscriptions(2);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List processInstances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).tenantId(TENANT_ONE).evaluateStartConditions();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        this.engineRule.getIdentityService().clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_ONE}).count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_TWO}).count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledTenantCheck() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.ensureEventSubscriptions(2);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        try {
            this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No subscriptions were found during evaluation of the conditional start events."));
        }
        finally {
            this.engineRule.getIdentityService().clearAuthentication();
        }
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Test
    public void testFailToEvaluateConditionByProcessDefinitionIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.ensureEventSubscriptions(1);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("conditionStart").singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot create an instance of the process definition");
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().createConditionEvaluation().setVariable("foo", (Object)"bar").processDefinitionId(processDefinition.getId()).evaluateStartConditions();
    }

    @Test
    public void testEvaluateConditionByProcessDefinitionIdWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.ensureEventSubscriptions(1);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("conditionStart").singleResult();
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List instances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariable("foo", (Object)"bar").tenantId(TENANT_ONE).processDefinitionId(processDefinition.getId()).evaluateStartConditions();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((ProcessInstance)instances.get(0)).getTenantId());
        this.engineRule.getIdentityService().clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_ONE}).count());
        EventSubscription eventSubscription = (EventSubscription)this.engineRule.getRuntimeService().createEventSubscriptionQuery().singleResult();
        Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)eventSubscription.getEventType());
    }

    protected void ensureEventSubscriptions(int count) {
        List eventSubscriptions = this.engineRule.getRuntimeService().createEventSubscriptionQuery().list();
        Assert.assertEquals((long)count, (long)eventSubscriptions.size());
        for (EventSubscription eventSubscription : eventSubscriptions) {
            Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)eventSubscription.getEventType());
        }
    }
}

