/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderCaseInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.util.IncrementCounterListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class RestartProcessInstanceSyncTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected TenantIdProvider defaultTenantIdProvider;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.defaultTenantIdProvider = this.engineRule.getProcessEngineConfiguration().getTenantIdProvider();
    }

    @After
    public void reset() {
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider(this.defaultTenantIdProvider);
    }

    @Test
    public void shouldRestartSimpleProcessInstance() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).active().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        Task restartedTask = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
    }

    @Test
    public void shouldRestartProcessInstanceWithTwoTasks() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task userTask1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).active().singleResult();
        this.taskService.complete(userTask1.getId());
        Task userTask2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).active().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask2")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        Task restartedTask = (Task)this.taskService.createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)userTask2.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("userTask2").done());
    }

    @Test
    public void shouldRestartProcessInstanceWithParallelGateway() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).startBeforeActivity("userTask2")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("userTask1").activity("userTask2").done());
    }

    @Test
    public void shouldRestartProcessInstanceWithSubProcess() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("subProcess")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).beginScope("subProcess").activity("userTask").done());
    }

    @Test
    public void shouldRestartProcessInstanceWithVariables() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask1").camundaExecutionListenerClass("end", SetVariableExecutionListenerImpl.class.getName())).userTask("userTask2").endEvent().done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)"bar");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).active().singleResult();
        this.taskService.complete(task.getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).singleResult();
        Assert.assertEquals((Object)variableInstance.getExecutionId(), (Object)restartedProcessInstance.getId());
        Assert.assertEquals((Object)"var", (Object)variableInstance.getName());
        Assert.assertEquals((Object)"foo", (Object)variableInstance.getValue());
    }

    @Test
    public void shouldRestartProcessInstanceWithInitialVariables() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent("startEvent").userTask("userTask1").camundaExecutionListenerClass("end", SetVariableExecutionListenerImpl.class.getName())).userTask("userTask2").endEvent().done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("var", (Object)"bar"));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).active().singleResult();
        this.taskService.complete(task.getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).initialSetOfVariables().processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).singleResult();
        Assert.assertEquals((Object)variableInstance.getExecutionId(), (Object)restartedProcessInstance.getId());
        Assert.assertEquals((Object)"var", (Object)variableInstance.getName());
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Test
    public void shouldNotSetLocalVariables() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Execution subProcess = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("userTask").singleResult();
        this.runtimeService.setVariableLocal(subProcess.getId(), "local", (Object)"foo");
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)"bar");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"var", (Object)((VariableInstance)variables.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)variables.get(0)).getValue());
    }

    @Test
    public void shouldNotSetInitialVersionOfLocalVariables() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("var", (Object)"bar"));
        Execution subProcess = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("userTask").singleResult();
        this.runtimeService.setVariableLocal(subProcess.getId(), "local", (Object)"foo");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).initialSetOfVariables().execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"var", (Object)((VariableInstance)variables.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)variables.get(0)).getValue());
    }

    @Test
    public void shouldNotSetInitialVersionOfVariables() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("var", (Object)"bar"));
        this.runtimeService.setVariable(processInstance.getId(), "bar", (Object)"foo");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).initialSetOfVariables().execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"var", (Object)((VariableInstance)variables.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)variables.get(0)).getValue());
    }

    @Test
    public void shouldRestartProcessInstanceUsingHistoricProcessInstanceQuery() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).historicProcessInstanceQuery(historicProcessInstanceQuery).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("userTask1").done());
    }

    @Test
    public void restartProcessInstanceWithNullProcessDefinitionId() {
        try {
            this.runtimeService.restartProcessInstances(null).execute();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processDefinitionId is null"));
        }
    }

    @Test
    public void restartProcessInstanceWithoutProcessInstanceIds() {
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances("foo").startAfterActivity("bar")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processInstanceIds is empty"));
        }
    }

    @Test
    public void restartProcessInstanceWithoutInstructions() {
        try {
            this.runtimeService.restartProcessInstances("foo").processInstanceIds(new String[]{"bar"}).execute();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Restart instructions cannot be empty"));
        }
    }

    @Test
    public void restartProcessInstanceWithNullProcessInstanceId() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startAfterActivity("bar")).processInstanceIds(new String[]{null}).execute();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids cannot be null"));
        }
    }

    @Test
    public void restartNotExistingProcessInstance() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("bar")).processInstanceIds(new String[]{"aaa"}).execute();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Historic process instance cannot be found"));
        }
    }

    @Test
    public void restartProcessInstanceWithNotMatchingProcessDefinition() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"Process2").startEvent().userTask().endEvent().done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        ProcessDefinition processDefinition2 = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Its process definition '" + processDefinition2.getId() + "' does not match given process definition '" + processDefinition.getId() + "'")));
        }
    }

    @Test
    public void shouldRestartProcessInstanceWithoutBusinessKey() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", "businessKey", (String)null);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).withoutBusinessKey().execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        Assert.assertNull((Object)restartedProcessInstance.getBusinessKey());
    }

    @Test
    public void shouldRestartProcessInstanceWithBusinessKey() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", "businessKey", (String)null);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        Assert.assertNotNull((Object)restartedProcessInstance.getBusinessKey());
        Assert.assertEquals((Object)"businessKey", (Object)restartedProcessInstance.getBusinessKey());
    }

    @Test
    public void shouldRestartProcessInstanceWithoutCaseInstanceId() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", null, "caseInstanceId");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        Assert.assertNull((Object)restartedProcessInstance.getCaseInstanceId());
    }

    @Test
    public void shouldRestartProcessInstanceWithTenant() {
        ProcessDefinition processDefinition = this.testRule.deployForTenantAndGetDefinition("tenantId", ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().singleResult();
        Assert.assertNotNull((Object)restartedProcessInstance.getTenantId());
        Assert.assertEquals((Object)processInstance.getTenantId(), (Object)restartedProcessInstance.getTenantId());
    }

    @Test
    public void shouldSkipCustomListeners() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).activityBuilder("userTask1").camundaExecutionListenerClass("start", IncrementCounterListener.class.getName()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        IncrementCounterListener.counter = 0;
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).skipCustomListeners().execute();
        Assert.assertEquals((long)0L, (long)IncrementCounterListener.counter);
    }

    @Test
    public void shouldSkipIoMappings() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).activityBuilder("userTask1").camundaInputParameter("foo", "bar").done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).skipIoMappings().processInstanceIds(new String[]{processInstance.getId()}).execute();
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertNull((Object)this.runtimeService.getVariable(task1Execution.getId(), "foo"));
    }

    @Test
    public void shouldRetainTenantIdOfSharedProcessDefinition() {
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new TestTenantIdProvider());
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((Object)processInstance.getTenantId(), (Object)"testTenantId");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)"testTenantId");
    }

    @Test
    public void shouldSkipTenantIdProviderOnRestart() {
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new TestTenantIdProvider());
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((Object)processInstance.getTenantId(), (Object)"testTenantId");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new FailingTenantIdProvider());
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)"testTenantId");
    }

    @Test
    public void shouldNotSetInitialVariablesIfThereIsNoUniqueStartActivity() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).startBeforeActivity("userTask1")).startBeforeActivity("userTask2")).setVariable("foo", (Object)"bar")).execute();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).initialSetOfVariables().processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).singleResult();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).list();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void shouldNotRestartActiveProcessInstance() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.thrown.expect(ProcessEngineException.class);
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).initialSetOfVariables().processInstanceIds(new String[]{processInstance.getId()}).execute();
    }

    public static class FailingTenantIdProvider
    implements TenantIdProvider {
        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestTenantIdProvider
    extends FailingTenantIdProvider {
        static final String TENANT_ID = "testTenantId";

        @Override
        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return TENANT_ID;
        }
    }

    public static class SetVariableExecutionListenerImpl
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            execution.setVariable("var", (Object)"foo");
        }
    }
}

