/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.List;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;

public class SignalEventDeploymentTest
extends PluggableProcessEngineTestCase {
    private static final String SIGNAL_START_EVENT_PROCESS = "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml";
    private static final String SIGNAL_START_EVENT_PROCESS_NEW_VERSION = "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent_v2.bpmn20.xml";

    public void testCreateEventSubscriptionOnDeployment() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS).deploy().getId();
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        SignalEventDeploymentTest.assertNotNull((Object)eventSubscription);
        SignalEventDeploymentTest.assertEquals((String)EventType.SIGNAL.name(), (String)eventSubscription.getEventType());
        SignalEventDeploymentTest.assertEquals((String)"alert", (String)eventSubscription.getEventName());
        SignalEventDeploymentTest.assertEquals((String)"start", (String)eventSubscription.getActivityId());
    }

    public void testUpdateEventSubscriptionOnDeployment() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS).deploy().getId();
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventType("signal").singleResult();
        SignalEventDeploymentTest.assertNotNull((Object)eventSubscription);
        SignalEventDeploymentTest.assertEquals((String)"alert", (String)eventSubscription.getEventName());
        String newDeploymentId = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS_NEW_VERSION).deploy().getId();
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult();
        SignalEventDeploymentTest.assertEquals((int)2, (int)newProcessDefinition.getVersion());
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("signal").list();
        SignalEventDeploymentTest.assertEquals((int)1, (int)newEventSubscriptions.size());
        EventSubscriptionEntity newEventSubscription = (EventSubscriptionEntity)newEventSubscriptions.iterator().next();
        SignalEventDeploymentTest.assertEquals((String)newProcessDefinition.getId(), (String)newEventSubscription.getConfiguration());
        SignalEventDeploymentTest.assertEquals((String)"abort", (String)newEventSubscription.getEventName());
        this.repositoryService.deleteDeployment(newDeploymentId);
    }

    public void testAsyncSignalStartEventDeleteDeploymentWhileAsync() {
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS).addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        SignalEventDeploymentTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            SignalEventDeploymentTest.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().count());
        }
    }
}

