/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;

public class SentryVariableOnPartExitCriteriaTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithVariableOnPart.cmmn"})
    public void testExitTaskWithVariableOnPartSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("variable_1", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithVariableOnPart.cmmn"})
    public void testExitTaskWithVariableOnPartNotSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("variable", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)secondHumanTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithMultipleOnPart.cmmn"})
    public void testExitTaskWithMultipleOnPartSatisfied() {
        this.createCaseInstance();
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)humanTask1.isActive());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartExitCriteriaTest.assertTrue((boolean)humanTask2.isActive());
        this.complete(humanTask1.getId());
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartExitCriteriaTest.assertNotNull((Object)stageExecution);
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)99);
        stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartExitCriteriaTest.assertNotNull((Object)stageExecution);
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)101);
        stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)stageExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTasksOfDifferentScopes.cmmn"})
    public void testExitMultipleTasksOfDifferentScopes() {
        this.createCaseInstance();
        CaseExecution stageExecution1 = this.queryCaseExecutionByActivityId("Stage_1");
        this.caseService.setVariable(stageExecution1.getId(), "value", (Object)101);
        stageExecution1 = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)stageExecution1);
        CaseExecution stageExecution2 = this.queryCaseExecutionByActivityId("Stage_2");
        SentryVariableOnPartExitCriteriaTest.assertNull((Object)stageExecution2);
    }
}

