/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricProcessInstanceManagerTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static final String TWO_TASKS_PROCESS = "twoTasksProcess";
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private RuntimeService runtimeService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testCountHistoricProcessInstanceIdsForCleanup() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                HistoricProcessInstanceManagerTest.this.updateTimeToLive(commandContext, HistoricProcessInstanceManagerTest.ONE_TASK_PROCESS, 3);
                HistoricProcessInstanceManagerTest.this.updateTimeToLive(commandContext, HistoricProcessInstanceManagerTest.TWO_TASKS_PROCESS, 5);
                return null;
            }
        });
        List<String> ids = this.prepareHistoricProcesses(ONE_TASK_PROCESS, 35);
        ids.addAll(this.prepareHistoricProcesses(TWO_TASKS_PROCESS, 65));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)4));
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                Long count = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanupCount();
                Assert.assertEquals((long)35L, (long)count);
                return null;
            }
        });
    }

    private void updateTimeToLive(CommandContext commandContext, String businessKey, int timeToLive) {
        List processDefinitions = this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(businessKey).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinitionEntity processDefinition1 = (ProcessDefinitionEntity)processDefinitions.get(0);
        processDefinition1.setHistoryTimeToLive(Integer.valueOf(timeToLive));
        commandContext.getDbEntityManager().merge((DbEntity)processDefinition1);
    }

    private List<String> prepareHistoricProcesses(String businessKey, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }
}

