/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.AfterClass;
import org.junit.Test;

public class DurationHelperTest {
    @Test
    public void shouldNotExceedNumber() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(0L));
        DurationHelper dh = new DurationHelper("R2/PT10S");
        ClockUtil.setCurrentTime((Date)new Date(15000L));
        TestCase.assertEquals((long)20000L, (long)dh.getDateAfter().getTime());
        ClockUtil.setCurrentTime((Date)new Date(30000L));
        Assert.assertNull((Object)dh.getDateAfter());
    }

    @Test
    public void shouldNotExceedNumberPeriods() throws Exception {
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:00"));
        DurationHelper dh = new DurationHelper("R2/1970-01-01T00:00:00/1970-01-01T00:00:10");
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:15"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:20"), (Object)dh.getDateAfter());
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:30"));
        Assert.assertNull((Object)dh.getDateAfter());
    }

    @Test
    public void shouldNotExceedNumberNegative() throws Exception {
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:00"));
        DurationHelper dh = new DurationHelper("R2/PT10S/1970-01-01T00:00:50");
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:20"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:30"), (Object)dh.getDateAfter());
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:35"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:40"), (Object)dh.getDateAfter());
    }

    @AfterClass
    public static void resetTime() {
        ClockUtil.reset();
    }

    private Date parse(String str) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        return simpleDateFormat.parse(str);
    }
}

