/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class CaseServiceTest
extends PluggableProcessEngineTestCase {
    public void testCreateCaseInstanceQuery() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }

    public void testCreateCaseExecutionQuery() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }

    public void testWithCaseExecution() {
        CaseExecutionCommandBuilder builder = this.caseService.withCaseExecution("aCaseExecutionId");
        CaseServiceTest.assertNotNull((Object)builder);
    }

    public void testManualStartInvalidCaseExecution() {
        try {
            this.caseService.withCaseExecution("invalid").manualStart();
            CaseServiceTest.fail();
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).manualStart();
            CaseServiceTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testCompleteInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").complete();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).complete();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testCloseInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").close();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).close();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testTerminateInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").terminate();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).terminate();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)Variables.stringValue((String)"abc")).setVariable("anotherVariableName", (Object)Variables.integerValue(null)).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariables((Map)variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariable("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableAndVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariables((Map)variables).setVariable("aThirdVariable", (Object)Variables.booleanValue(null)).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.booleanValue(null), (Object)variable.getTypedValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariablesLocalTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal((Map)variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)1, (int)result.size());
        VariableInstance aThirdVariable = (VariableInstance)result.get(0);
        CaseServiceTest.assertNotNull((Object)aThirdVariable);
        CaseServiceTest.assertEquals((String)"aThirdVariable", (String)aThirdVariable.getName());
        CaseServiceTest.assertEquals((Object)123, (Object)aThirdVariable.getValue());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").removeVariable("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("aThirdVariable", (Object)123).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariable("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        this.caseService.withCaseExecution(caseExecutionId).removeVariableLocal("aVariableName").removeVariableLocal("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveAndSetSameVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").setVariable("aVariableName", (Object)"xyz").execute();
        }
        catch (NotValidException e) {
            this.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveAndSetSameLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"xyz").removeVariableLocal("aVariableName").execute();
        }
        catch (NotValidException e) {
            this.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Map variables = this.caseService.getVariables(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesTyped(caseExecutionId, true));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = this.caseService.getVariablesTyped(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        CaseServiceTest.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesTyped(caseExecutionId, true));
    }

    public void testGetVariablesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariables(caseExecutionId, names);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariables(caseExecutionId, names));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesWithVariableNamesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        VariableMap variables = this.caseService.getVariablesTyped(caseExecutionId, names, true);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        CaseServiceTest.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariables(caseExecutionId, names));
    }

    public void testGetVariablesWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid", null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null, null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Map variables = this.caseService.getVariablesLocal(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        CaseServiceTest.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocalTyped(caseExecutionId, true));
    }

    public void testGetVariablesLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariablesLocal(caseExecutionId, names);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId, names));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalWithVariableNamesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseExecutionId, names, true);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        CaseServiceTest.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        CaseServiceTest.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId, names));
    }

    public void testGetVariablesLocalWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid", null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null, null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Object value = this.caseService.getVariable(caseExecutionId, "aVariableName");
        CaseServiceTest.assertNotNull((Object)value);
        CaseServiceTest.assertEquals((Object)"abc", (Object)value);
    }

    public void testGetVariableInvalidCaseExecutionId() {
        try {
            this.caseService.getVariable("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariable(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Object value = this.caseService.getVariableLocal(caseExecutionId, "aVariableName");
        CaseServiceTest.assertNotNull((Object)value);
        CaseServiceTest.assertEquals((Object)"abc", (Object)value);
    }

    public void testGetVariableLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableLocal("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariableLocal(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariableTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("aSerializedObject", (Object)Variables.objectValue(Arrays.asList("1", "2")).create()).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        StringValue stringValue = (StringValue)this.caseService.getVariableTyped(caseExecutionId, "aVariableName");
        ObjectValue objectValue = (ObjectValue)this.caseService.getVariableTyped(caseExecutionId, "aSerializedObject");
        ObjectValue serializedObjectValue = (ObjectValue)this.caseService.getVariableTyped(caseExecutionId, "aSerializedObject", false);
        CaseServiceTest.assertNotNull((Object)stringValue.getValue());
        CaseServiceTest.assertNotNull((Object)objectValue.getValue());
        CaseServiceTest.assertTrue((boolean)objectValue.isDeserialized());
        CaseServiceTest.assertEquals(Arrays.asList("1", "2"), (Object)objectValue.getValue());
        CaseServiceTest.assertFalse((boolean)serializedObjectValue.isDeserialized());
        CaseServiceTest.assertNotNull((Object)serializedObjectValue.getValueSerialized());
    }

    public void testGetVariableTypedInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableTyped("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariableTyped(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSetVariable() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariable(caseExecutionId, "aVariableName", (Object)"abc");
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)1, (int)result.size());
        VariableInstance variable = (VariableInstance)result.get(0);
        CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSetVariables() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 123);
        this.caseService.setVariables(caseExecutionId, variables);
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSetVariableLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "aVariableName", (Object)"abc");
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)1, (int)result.size());
        VariableInstance variable = (VariableInstance)result.get(0);
        CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
        CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSetVariablesLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 123);
        this.caseService.setVariablesLocal(caseExecutionId, variables);
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariableTypedLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).setVariableLocal("aSerializedObject", (Object)Variables.objectValue(Arrays.asList("1", "2")).create()).execute();
        StringValue stringValue = (StringValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aVariableName");
        ObjectValue objectValue = (ObjectValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aSerializedObject");
        ObjectValue serializedObjectValue = (ObjectValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aSerializedObject", false);
        CaseServiceTest.assertNotNull((Object)stringValue.getValue());
        CaseServiceTest.assertNotNull((Object)objectValue.getValue());
        CaseServiceTest.assertTrue((boolean)objectValue.isDeserialized());
        CaseServiceTest.assertEquals(Arrays.asList("1", "2"), (Object)objectValue.getValue());
        CaseServiceTest.assertFalse((boolean)serializedObjectValue.isDeserialized());
        CaseServiceTest.assertNotNull((Object)serializedObjectValue.getValueSerialized());
    }

    public void testGetVariableLocalTypedInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableLocalTyped("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariableLocalTyped(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testRemoveVariable() {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.removeVariable(caseExecutionId, "aVariableName");
        CaseServiceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testRemoveVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariable", "abc");
        variables.put("anotherVariable", 123);
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariables(variables).setVariable("aThirdVariable", (Object)"def").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.removeVariables(caseExecutionId, variables.keySet());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceTest.assertNotNull((Object)variable);
        CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testRemoveVariableLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "aVariableName", (Object)"abc");
        this.caseService.removeVariableLocal(caseInstanceId, "aVariableName");
        CaseServiceTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        this.caseService.removeVariableLocal(caseExecutionId, "aVariableName");
        CaseServiceTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testRemoveVariablesLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariable", "abc");
        variables.put("anotherVariable", 123);
        this.caseService.setVariablesLocal(caseExecutionId, variables);
        this.caseService.setVariableLocal(caseExecutionId, "aThirdVariable", (Object)"def");
        this.caseService.removeVariablesLocal(caseInstanceId, variables.keySet());
        CaseServiceTest.assertEquals((long)3L, (long)this.runtimeService.createVariableInstanceQuery().count());
        this.caseService.removeVariablesLocal(caseExecutionId, variables.keySet());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceTest.assertNotNull((Object)variable);
        CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    public void testCreateCaseInstanceById() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseServiceTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        CaseServiceTest.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    public void testCreateCaseInstanceByKey() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseServiceTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        CaseServiceTest.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    public void testCaseExecutionQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseServiceTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        List caseExecutions = this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstance.getId()).list();
        CaseServiceTest.assertEquals((int)3, (int)caseExecutions.size());
        CaseExecution casePlanModelExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("CasePlanModel_1").singleResult();
        CaseServiceTest.assertNotNull((Object)casePlanModelExecution);
        CaseExecution stageExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceTest.assertNotNull((Object)stageExecution);
        CaseExecution humanTaskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_6").singleResult();
        CaseServiceTest.assertNotNull((Object)humanTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    public void testCaseInstanceQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseServiceTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        List caseInstances = this.caseService.createCaseInstanceQuery().active().list();
        CaseServiceTest.assertEquals((int)1, (int)caseInstances.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Map variables = this.caseService.getVariables(caseInstanceId, new ArrayList());
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesTypedByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        VariableMap variables = this.caseService.getVariablesTyped(caseInstanceId, new ArrayList(), false);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Map variables = this.caseService.getVariablesLocal(caseInstanceId, new ArrayList());
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalTypedByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseInstanceId, new ArrayList(), false);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertTrue((boolean)variables.isEmpty());
    }
}

