/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;

public class JobDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByNoCriteria() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByJobDefinitionId() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        JobDefinitionQueryTest.assertEquals((String)jobDefinition.getId(), (String)((JobDefinition)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidJobDefinitionId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobDefinitionId(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByActivityId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1"});
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1"});
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1", "StartEvent_1"});
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1", "StartEvent_1", "IntermediateCatchEvent_1"});
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidActivityId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().activityIdIn(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{null});
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionId(processDefinition.getId());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidDefinitionId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().processDefinitionId(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinition.getKey());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidDefinitionKey() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().processDefinitionKey(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByJobType() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobType("async-continuation");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-start-event");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-transition");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidJobType() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobType(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByInvalidJobConfiguration() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobConfiguration("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobConfiguration(null);
            JobDefinitionQueryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryByActive() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().active();
        this.verifyQueryResults(query, 4);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("async-continuation").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 2);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryBySuspended() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().suspended();
        this.verifyQueryResults(query, 0);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("async-continuation").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 2);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryPaging() {
        JobDefinitionQueryTest.assertEquals((int)4, (int)this.managementService.createJobDefinitionQuery().listPage(0, 4).size());
        JobDefinitionQueryTest.assertEquals((int)1, (int)this.managementService.createJobDefinitionQuery().listPage(2, 1).size());
        JobDefinitionQueryTest.assertEquals((int)2, (int)this.managementService.createJobDefinitionQuery().listPage(1, 2).size());
        JobDefinitionQueryTest.assertEquals((int)3, (int)this.managementService.createJobDefinitionQuery().listPage(1, 4).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQuerySorting() {
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByActivityId().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobConfiguration().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobType().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionId().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionKey().asc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByActivityId().desc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobConfiguration().desc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().desc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobType().desc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionId().desc()).list().size());
        JobDefinitionQueryTest.assertEquals((int)4, (int)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionKey().desc()).list().size());
    }

    public void testQueryInvalidSortingUsage() {
        try {
            this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().list();
            JobDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.managementService.createJobQuery().asc();
            JobDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("You should call any of the orderBy methods first before specifying a direction", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    public void testQueryWithOverridingJobPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().listPage(0, 1).get(0);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        JobDefinition queriedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().withOverridingJobPriority().singleResult();
        JobDefinitionQueryTest.assertNotNull((Object)queriedDefinition);
        JobDefinitionQueryTest.assertEquals((String)jobDefinition.getId(), (String)queriedDefinition.getId());
        JobDefinitionQueryTest.assertEquals((long)42L, (long)queriedDefinition.getOverridingJobPriority());
        JobDefinitionQueryTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().withOverridingJobPriority().count());
    }

    private void verifyQueryResults(JobDefinitionQuery query, int countExpected) {
        JobDefinitionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        JobDefinitionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            JobDefinitionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            JobDefinitionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(JobDefinitionQuery query) {
        try {
            query.singleResult();
            JobDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

