/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.ExternalTaskQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class ExternalTaskManager
extends AbstractManager {
    public static QueryOrderingProperty EXT_TASK_PRIORITY_ORDERING_PROPERTY = new QueryOrderingProperty(ExternalTaskQueryProperty.PRIORITY, Direction.DESCENDING);

    public ExternalTaskEntity findExternalTaskById(String id) {
        return this.getDbEntityManager().selectById(ExternalTaskEntity.class, id);
    }

    public void insert(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().insert(externalTask);
    }

    public void delete(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().delete(externalTask);
    }

    public List<ExternalTaskEntity> findExternalTasksByExecutionId(String id) {
        return this.getDbEntityManager().selectList("selectExternalTasksByExecutionId", id);
    }

    public List<ExternalTaskEntity> findExternalTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectExternalTasksByExecutionId", processInstanceId);
    }

    public List<ExternalTaskEntity> selectExternalTasksForTopics(Collection<TopicFetchInstruction> queryFilters, boolean filterByBusinessKey, int maxResults, boolean usePriority) {
        if (queryFilters.isEmpty()) {
            return new ArrayList<ExternalTaskEntity>();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("topics", queryFilters);
        parameters.put("businessKeyFilter", filterByBusinessKey);
        parameters.put("now", ClockUtil.getCurrentTime());
        parameters.put("applyOrdering", usePriority);
        ArrayList<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();
        orderingProperties.add(EXT_TASK_PRIORITY_ORDERING_PROPERTY);
        parameters.put("orderingProperties", orderingProperties);
        ListQueryParameterObject parameter = new ListQueryParameterObject(parameters, 0, maxResults);
        this.configureQuery(parameter);
        DbEntityManager manager = this.getDbEntityManager();
        return manager.selectList("selectExternalTasksForTopics", parameter);
    }

    public List<ExternalTask> findExternalTasksByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskByQueryCriteria", externalTaskQuery);
    }

    public List<String> findExternalTaskIdsByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskIdsByQueryCriteria", externalTaskQuery);
    }

    public long findExternalTaskCountByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return (Long)this.getDbEntityManager().selectOne("selectExternalTaskCountByQueryCriteria", externalTaskQuery);
    }

    protected void updateExternalTaskSuspensionState(String processInstanceId, String processDefinitionId, String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateExternalTaskSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(processInstanceId, null, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, processDefinitionId, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, null, processDefinitionKey, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void configureQuery(ExternalTaskQueryImpl query) {
        this.getAuthorizationManager().configureExternalTaskQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected void configureQuery(ListQueryParameterObject parameter) {
        this.getAuthorizationManager().configureExternalTaskFetch(parameter);
        this.getTenantManager().configureQuery(parameter);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

