/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ConditionalStartEventTest {
    private static final String SINGLE_CONDITIONAL_XML = "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml";
    private static final String MULTIPLE_CONDITIONS = "multipleConditions";
    private static final String TRUE_CONDITION_PROCESS = "trueConditionProcess";
    private static final String CONDITIONAL_EVENT_PROCESS = "conditionalEventProcess";
    private static final BpmnModelInstance MODEL_WITHOUT_CONDITION = Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;

    @Before
    public void setUp() throws Exception {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testDeploymentCreatesSubscriptions() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(CONDITIONAL_EVENT_PROCESS).singleResult()).getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        EventSubscriptionEntity conditionalEventSubscription = (EventSubscriptionEntity)eventSubscriptions.get(0);
        Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)conditionalEventSubscription.getEventType());
        Assert.assertEquals((Object)processDefinitionId, (Object)conditionalEventSubscription.getConfiguration());
        Assert.assertNull((Object)conditionalEventSubscription.getEventName());
        Assert.assertNull((Object)conditionalEventSubscription.getExecutionId());
        Assert.assertNull((Object)conditionalEventSubscription.getProcessInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testUpdateProcessVersionCancelsSubscriptions() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.testRule.deploy("org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml");
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List newProcessDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)newEventSubscriptions.size());
        Assert.assertEquals((long)2L, (long)newProcessDefinitions.size());
        for (ProcessDefinition processDefinition : newProcessDefinitions) {
            EventSubscriptionEntity subscriptionEntity;
            if (processDefinition.getVersion() == 1) {
                for (EventSubscription subscription : newEventSubscriptions) {
                    subscriptionEntity = (EventSubscriptionEntity)subscription;
                    Assert.assertFalse((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
                }
                continue;
            }
            for (EventSubscription subscription : newEventSubscriptions) {
                subscriptionEntity = (EventSubscriptionEntity)subscription;
                Assert.assertTrue((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
            }
        }
        Assert.assertFalse((boolean)eventSubscriptions.equals(newEventSubscriptions));
    }

    @Test
    @Ignore(value="CAM-8666")
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testEventSubscriptionAfterDeleteLatestProcessVersion() {
        ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinitionV1);
        String deploymentId = this.testRule.deploy(SINGLE_CONDITIONAL_XML).getId();
        this.repositoryService.deleteDeployment(deploymentId, true);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(CONDITIONAL_EVENT_PROCESS).singleResult();
        Assert.assertEquals((Object)processDefinitionV1.getId(), (Object)processDefinition.getId());
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)eventSubscription);
        Assert.assertEquals((Object)processDefinitionV1.getId(), (Object)eventSubscription.getConfiguration());
    }

    @Test
    @Ignore(value="CAM-8666")
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceAfterDeleteLatestProcessVersion() {
        String deploymentId = this.testRule.deploy(SINGLE_CONDITIONAL_XML).getId();
        org.camunda.bpm.engine.repository.Deployment deployment = (org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        List conditionInstances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)conditionInstances.size());
        Assert.assertNotNull(conditionInstances.get(0));
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testVersionWithoutConditionAfterDeleteLatestProcessVersionWithCondition() {
        this.testRule.deploy(MODEL_WITHOUT_CONDITION);
        String deploymentId = this.testRule.deploy(SINGLE_CONDITIONAL_XML).getId();
        org.camunda.bpm.engine.repository.Deployment deployment = (org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No subscriptions were found during evaluation of the conditional start events.");
        this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).evaluateStartConditions();
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByKeys() {
        this.testRule.deploy(SINGLE_CONDITIONAL_XML);
        this.testRule.deploy(SINGLE_CONDITIONAL_XML);
        this.testRule.deploy(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byKey(CONDITIONAL_EVENT_PROCESS).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByIdOrdered() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByIdReverseOrder() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId3, definitionId2, definitionId1}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById1() {
        String definitionId1 = this.deployModel(MODEL_WITHOUT_CONDITION);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById2() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployModel(MODEL_WITHOUT_CONDITION);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById3() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployModel(MODEL_WITHOUT_CONDITION);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction1() {
        String definitionId1 = this.deployModel(MODEL_WITHOUT_CONDITION);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction2() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployModel(MODEL_WITHOUT_CONDITION);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction3() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployModel(MODEL_WITHOUT_CONDITION);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testDeleteNotLatestVersion() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId3, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    @Ignore(value="CAM-8666")
    public void testSubscribePreviousPreviousVersion() {
        String definitionId1 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId2 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        String definitionId3 = this.deployProcess(SINGLE_CONDITIONAL_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    public void testDeploymentOfTwoEqualConditionalStartEvent() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot have more than one conditional event subscription with the same condition '${variable == 1}'");
        this.testRule.deploy("org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testTwoEqualConditionalStartEvent.bpmn20.xml");
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)0L, (long)eventSubscriptions.size());
    }

    @Test
    @Deployment
    public void testStartInstanceWithTrueConditionalStartEvent() {
        List conditionInstances = this.runtimeService.createConditionEvaluation().evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)conditionInstances.size());
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(TRUE_CONDITION_PROCESS).list();
        Assert.assertEquals((long)1L, (long)processInstances.size());
        Assert.assertEquals((Object)((ProcessInstance)processInstances.get(0)).getId(), (Object)((ProcessInstance)conditionInstances.get(0)).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceWithVariableCondition() {
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
        VariableInstance vars = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)vars.getProcessInstanceId(), (Object)((ProcessInstance)instances.get(0)).getId());
        Assert.assertEquals((Object)1, (Object)vars.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceWithTransientVariableCondition() {
        VariableMap variableMap = Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.integerValue((Integer)1, (boolean)true));
        List instances = this.runtimeService.createConditionEvaluation().setVariables((Map)variableMap).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
        VariableInstance vars = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNull((Object)vars);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceWithoutResult() {
        List processes = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)0).evaluateStartConditions();
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)0L, (long)processes.size());
        Assert.assertNull((Object)this.runtimeService.createVariableInstanceQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(CONDITIONAL_EVENT_PROCESS).singleResult());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testMultipleCondition.bpmn20.xml"})
    public void testStartInstanceWithMultipleConditions() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)3L, (long)eventSubscriptions.size());
        for (EventSubscription eventSubscription : eventSubscriptions) {
            Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)eventSubscription.getEventType());
        }
        HashMap<String, Constable> variableMap = new HashMap<String, Constable>();
        variableMap.put("foo", Integer.valueOf(1));
        variableMap.put("bar", Boolean.valueOf(true));
        List resultInstances = this.runtimeService.createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertEquals((long)2L, (long)resultInstances.size());
        List instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(MULTIPLE_CONDITIONS).list();
        Assert.assertEquals((long)2L, (long)instances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testMultipleCondition.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceWithMultipleSubscriptions() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)5L, (long)eventSubscriptions.size());
        HashMap<String, Constable> variableMap = new HashMap<String, Constable>();
        variableMap.put("foo", Integer.valueOf(1));
        variableMap.put("bar", Boolean.valueOf(true));
        List instances = this.runtimeService.createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertEquals((long)4L, (long)instances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testMultipleCondition.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceWithMultipleSubscriptionsWithoutProvidingAllVariables() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)5L, (long)eventSubscriptions.size());
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        variableMap.put("foo", 1);
        List instances = this.runtimeService.createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertEquals((long)3L, (long)instances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testMultipleCondition.bpmn20.xml"})
    public void testStartInstanceWithBusinessKey() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)4L, (long)eventSubscriptions.size());
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).processInstanceBusinessKey("humuhumunukunukuapua").evaluateStartConditions();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("humuhumunukunukuapua").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceByProcessDefinitionId() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)2L, (long)eventSubscriptions.size());
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(TRUE_CONDITION_PROCESS).singleResult()).getId();
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).processDefinitionId(processDefinitionId).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processDefinitionId, (Object)((ProcessInstance)instances.get(0)).getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testMultipleCondition.bpmn20.xml"})
    public void testStartInstanceByProcessDefinitionFirstVersion() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(CONDITIONAL_EVENT_PROCESS).singleResult()).getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)4L, (long)eventSubscriptions.size());
        this.testRule.deploy("org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml");
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).processDefinitionId(processDefinitionId).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processDefinitionId, (Object)((ProcessInstance)instances.get(0)).getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml"})
    public void testStartInstanceByNonExistingProcessDefinitionId() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)2L, (long)eventSubscriptions.size());
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("no deployed process definition found with id 'nonExistingId': processDefinition is null");
        this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).processDefinitionId("nonExistingId").evaluateStartConditions();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartInstanceByProcessDefinitionIdWithoutCondition() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)0L, (long)eventSubscriptions.size());
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Process definition with id '" + processDefinitionId + "' does not declare conditional start event");
        this.runtimeService.createConditionEvaluation().processDefinitionId(processDefinitionId).evaluateStartConditions();
    }

    @Test
    @Deployment
    public void testStartInstanceWithVariableName() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)true).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithVariableName.bpmn20.xml"})
    public void testStartInstanceWithVariableNameNotFullfilled() {
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        List instances = this.runtimeService.createConditionEvaluation().evaluateStartConditions();
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    protected String deployProcess(String resourcePath) {
        List deployedProcessDefinitions = this.testRule.deploy(resourcePath).getDeployedProcessDefinitions();
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        return ((ProcessDefinition)deployedProcessDefinitions.get(0)).getId();
    }

    protected String deployModel(BpmnModelInstance model) {
        List deployedProcessDefinitions = this.testRule.deploy(model).getDeployedProcessDefinitions();
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        String definitionId2 = ((ProcessDefinition)deployedProcessDefinitions.get(0)).getId();
        return definitionId2;
    }
}

