/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public abstract class HistoryCleanupHelper {
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS = new SimpleDateFormat("yyyy-MM-ddHH:mm");
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE = new SimpleDateFormat("yyyy-MM-ddHH:mmZ");
    private static final SimpleDateFormat DATE_FORMAT_WITHOUT_TIME = new SimpleDateFormat("yyyy-MM-dd");

    public static Date getCurrentOrNextRunWithinBatchWindow(Date date, CommandContext commandContext) {
        if (!HistoryCleanupHelper.isBatchWindowConfigured(commandContext)) {
            throw new ProcessEngineException("Batch window must be configured");
        }
        return HistoryCleanupHelper.getCurrentOrNextBatchWindowStartTime(date, HistoryCleanupHelper.getBatchWindowStartTime(commandContext), HistoryCleanupHelper.getBatchWindowEndTime(commandContext));
    }

    public static Date getNextRunWithinBatchWindow(Date date, CommandContext commandContext) {
        return HistoryCleanupHelper.getNextRunWithinBatchWindow(date, HistoryCleanupHelper.getBatchWindowStartTime(commandContext));
    }

    public static Date getNextRunWithinBatchWindow(Date date, Date batchWindowStartTime) {
        if (batchWindowStartTime != null) {
            Date todayPossibleRun = HistoryCleanupHelper.updateTime(date, batchWindowStartTime);
            if (todayPossibleRun.after(date)) {
                return todayPossibleRun;
            }
            return HistoryCleanupHelper.addDays(todayPossibleRun, 1);
        }
        throw new ProcessEngineException("Batch window must be configured");
    }

    public static Date getCurrentOrNextBatchWindowStartTime(Date date, Date startTime, Date endTime) {
        if (HistoryCleanupHelper.isWithinBatchWindow(date, startTime, endTime)) {
            Date todayStartTime = HistoryCleanupHelper.updateTime(date, startTime);
            if (todayStartTime.after(date)) {
                todayStartTime = HistoryCleanupHelper.addDays(todayStartTime, -1);
            }
            return todayStartTime;
        }
        return HistoryCleanupHelper.getNextRunWithinBatchWindow(date, startTime);
    }

    public static Date getNextBatchWindowEndTime(Date date, Date endTime) {
        Date todayEndTime = HistoryCleanupHelper.updateTime(date, endTime);
        if (todayEndTime.after(date)) {
            return todayEndTime;
        }
        return HistoryCleanupHelper.addDays(todayEndTime, 1);
    }

    public static Date getBatchWindowStartTime(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchWindowStartTimeAsDate();
    }

    public static Date getBatchWindowEndTime(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchWindowEndTimeAsDate();
    }

    public static boolean isBatchWindowConfigured(CommandContext commandContext) {
        return HistoryCleanupHelper.getBatchWindowStartTime(commandContext) != null;
    }

    public static boolean isWithinBatchWindow(Date date, CommandContext commandContext) {
        if (HistoryCleanupHelper.isBatchWindowConfigured(commandContext)) {
            Date batchWindowStartTime = HistoryCleanupHelper.getBatchWindowStartTime(commandContext);
            Date batchWindowEndTime = HistoryCleanupHelper.getBatchWindowEndTime(commandContext);
            return HistoryCleanupHelper.isWithinBatchWindow(date, batchWindowStartTime, batchWindowEndTime);
        }
        return false;
    }

    public static boolean isWithinBatchWindow(Date date, Date batchWindowStartTime, Date batchWindowEndTime) {
        Date todaysBatchWindowStartTime = HistoryCleanupHelper.updateTime(date, batchWindowStartTime);
        Date todaysBatchWindowEndTime = HistoryCleanupHelper.updateTime(date, batchWindowEndTime);
        if (todaysBatchWindowEndTime.after(todaysBatchWindowStartTime)) {
            return (date.after(todaysBatchWindowStartTime) || date.equals(todaysBatchWindowStartTime)) && date.before(todaysBatchWindowEndTime);
        }
        return date.after(todaysBatchWindowStartTime) || date.equals(todaysBatchWindowStartTime) || date.before(todaysBatchWindowEndTime);
    }

    public static Date updateTime(Date now, Date newTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        Calendar newTimeCalendar = Calendar.getInstance();
        newTimeCalendar.setTime(newTime);
        c.set(15, newTimeCalendar.get(15));
        c.set(16, newTimeCalendar.get(16));
        c.set(11, newTimeCalendar.get(11));
        c.set(12, newTimeCalendar.get(12));
        c.set(13, newTimeCalendar.get(13));
        c.set(14, newTimeCalendar.get(14));
        return c.getTime();
    }

    public static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public static synchronized Date parseTimeConfiguration(String time) throws ParseException {
        String today = DATE_FORMAT_WITHOUT_TIME.format(ClockUtil.getCurrentTime());
        try {
            return TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE.parse(today + time);
        }
        catch (ParseException ex) {
            return TIME_FORMAT_WITHOUT_SECONDS.parse(today + time);
        }
    }

    private static Integer getHistoryCleanupBatchSize(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }

    public static HistoryCleanupBatch getNextBatch(CommandContext commandContext) {
        List<String> historicBatchIds;
        List<String> historicCaseInstanceIds;
        List<String> historicDecisionInstanceIds;
        Integer batchSize = HistoryCleanupHelper.getHistoryCleanupBatchSize(commandContext);
        HistoryCleanupBatch historyCleanupBatch = new HistoryCleanupBatch();
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        List<String> historicProcessInstanceIds = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanup(batchSize);
        if (historicProcessInstanceIds.size() > 0) {
            historyCleanupBatch.setHistoricProcessInstanceIds(historicProcessInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isDmnEnabled() && (historicDecisionInstanceIds = commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceIdsForCleanup(batchSize - historyCleanupBatch.size())).size() > 0) {
            historyCleanupBatch.setHistoricDecisionInstanceIds(historicDecisionInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isCmmnEnabled() && (historicCaseInstanceIds = commandContext.getHistoricCaseInstanceManager().findHistoricCaseInstanceIdsForCleanup(batchSize - historyCleanupBatch.size())).size() > 0) {
            historyCleanupBatch.setHistoricCaseInstanceIds(historicCaseInstanceIds);
        }
        Map<String, Integer> batchOperationsForHistoryCleanup = processEngineConfiguration.getParsedBatchOperationsForHistoryCleanup();
        if (historyCleanupBatch.size() < batchSize && batchOperationsForHistoryCleanup != null && !batchOperationsForHistoryCleanup.isEmpty() && (historicBatchIds = commandContext.getHistoricBatchManager().findHistoricBatchIdsForCleanup(batchSize - historyCleanupBatch.size(), batchOperationsForHistoryCleanup)).size() > 0) {
            historyCleanupBatch.setHistoricBatchIds(historicBatchIds);
        }
        return historyCleanupBatch;
    }
}

