/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.plugin;

import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.plugin.AdministratorAuthorizationPluginLogger;

public class AdministratorAuthorizationPlugin
extends AbstractProcessEnginePlugin {
    private static final AdministratorAuthorizationPluginLogger LOG = ProcessEngineLogger.ADMIN_PLUGIN_LOGGER;
    protected String administratorGroupName;
    protected String administratorUserName;
    protected boolean authorizationEnabled;

    @Override
    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.authorizationEnabled = processEngineConfiguration.isAuthorizationEnabled();
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (this.administratorGroupName != null && this.administratorGroupName.length() > 0) {
            for (Resources resource : Resources.values()) {
                if (authorizationService.createAuthorizationQuery().groupIdIn(this.administratorGroupName).resourceType(resource).resourceId("*").count() != 0L) continue;
                AuthorizationEntity adminGroupAuth = new AuthorizationEntity(1);
                adminGroupAuth.setGroupId(this.administratorGroupName);
                adminGroupAuth.setResource(resource);
                adminGroupAuth.setResourceId("*");
                adminGroupAuth.addPermission(Permissions.ALL);
                authorizationService.saveAuthorization(adminGroupAuth);
                LOG.grantGroupPermissions(this.administratorGroupName, resource.resourceName());
            }
        }
        if (this.administratorUserName != null && this.administratorUserName.length() > 0) {
            for (Resources resource : Resources.values()) {
                if (authorizationService.createAuthorizationQuery().userIdIn(this.administratorUserName).resourceType(resource).resourceId("*").count() != 0L) continue;
                AuthorizationEntity adminUserAuth = new AuthorizationEntity(1);
                adminUserAuth.setUserId(this.administratorUserName);
                adminUserAuth.setResource(resource);
                adminUserAuth.setResourceId("*");
                adminUserAuth.addPermission(Permissions.ALL);
                authorizationService.saveAuthorization(adminUserAuth);
                LOG.grantUserPermissions(this.administratorUserName, resource.resourceName());
            }
        }
    }

    public String getAdministratorGroupName() {
        return this.administratorGroupName;
    }

    public void setAdministratorGroupName(String administratorGroupName) {
        this.administratorGroupName = administratorGroupName;
    }

    public String getAdministratorUserName() {
        return this.administratorUserName;
    }

    public void setAdministratorUserName(String administratorUserName) {
        this.administratorUserName = administratorUserName;
    }
}

