/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.io.IOException;
import java.io.ObjectInputStream;

/**
 * @author Daniel Meyer
 *
 */
public class FailingJavaSerializable extends JavaSerializable {

  public FailingJavaSerializable(String property) {
    super(property);
  }

  private static final long serialVersionUID = 1L;

  private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
    throw new RuntimeException("Exception while deserializing object.");
  }

}
