/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Job;

public class HistoryCleanupCmd
implements Command<Job> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    public static final JobDeclaration HISTORY_CLEANUP_JOB_DECLARATION = new HistoryCleanupJobDeclaration();
    public static final int MAX_THREADS_NUMBER = 8;
    private boolean immediatelyDue;

    public HistoryCleanupCmd(boolean immediatelyDue) {
        this.immediatelyDue = immediatelyDue;
    }

    @Override
    public Job execute(CommandContext commandContext) {
        boolean suspendJobs;
        List<Job> historyCleanupJobs;
        commandContext.getAuthorizationManager().checkCamundaAdmin();
        if (!this.willBeScheduled(commandContext)) {
            LOG.debugHistoryCleanupWrongConfiguration();
        }
        boolean createJobs = (historyCleanupJobs = commandContext.getJobManager().findJobsByHandlerType("history-cleanup")).isEmpty() && this.willBeScheduled(commandContext);
        boolean reconfigureJobs = !historyCleanupJobs.isEmpty() && this.willBeScheduled(commandContext);
        boolean bl = suspendJobs = !historyCleanupJobs.isEmpty() && !this.willBeScheduled(commandContext);
        if (createJobs) {
            commandContext.getPropertyManager().acquireExclusiveLockForHistoryCleanupJob();
            historyCleanupJobs = commandContext.getJobManager().findJobsByHandlerType("history-cleanup");
            if (historyCleanupJobs.isEmpty()) {
                int[][] minuteChunks;
                for (int[] minuteChunk : minuteChunks = HistoryCleanupHelper.listMinuteChunks(commandContext.getProcessEngineConfiguration().getHistoryCleanupDegreeOfParallelism())) {
                    Object jobInstance = HISTORY_CLEANUP_JOB_DECLARATION.createJobInstance(new HistoryCleanupContext(this.immediatelyDue, minuteChunk[0], minuteChunk[1]));
                    historyCleanupJobs.add((Job)jobInstance);
                    Context.getCommandContext().getJobManager().insertAndHintJobExecutor((JobEntity)jobInstance);
                }
            }
        } else if (reconfigureJobs) {
            Job job;
            int i;
            int degreeOfParallelism = commandContext.getProcessEngineConfiguration().getHistoryCleanupDegreeOfParallelism();
            int[][] minuteChunks = HistoryCleanupHelper.listMinuteChunks(commandContext.getProcessEngineConfiguration().getHistoryCleanupDegreeOfParallelism());
            for (i = 0; i < degreeOfParallelism; ++i) {
                int[] minuteChunk = minuteChunks[i];
                job = null;
                try {
                    job = historyCleanupJobs.get(i);
                    HistoryCleanupContext historyCleanupContext = new HistoryCleanupContext(this.immediatelyDue, minuteChunk[0], minuteChunk[1]);
                    JobEntity historyCleanupJob = (JobEntity)job;
                    HISTORY_CLEANUP_JOB_DECLARATION.reconfigure(historyCleanupContext, historyCleanupJob);
                    Date newDueDate = !this.immediatelyDue && historyCleanupJob.getDuedate() != null && HistoryCleanupHelper.isWithinBatchWindow(historyCleanupJob.getDuedate(), commandContext) ? historyCleanupJob.getDuedate() : HISTORY_CLEANUP_JOB_DECLARATION.resolveDueDate(historyCleanupContext);
                    commandContext.getJobManager().reschedule(historyCleanupJob, newDueDate);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    job = HISTORY_CLEANUP_JOB_DECLARATION.createJobInstance(new HistoryCleanupContext(this.immediatelyDue, minuteChunk[0], minuteChunk[1]));
                    historyCleanupJobs.add(job);
                    Context.getCommandContext().getJobManager().insertAndHintJobExecutor((JobEntity)job);
                }
            }
            while (i < historyCleanupJobs.size()) {
                job = historyCleanupJobs.get(i);
                Context.getCommandContext().getJobManager().deleteJob((JobEntity)job);
                ++i;
            }
        } else if (suspendJobs) {
            for (Job job : historyCleanupJobs) {
                JobEntity jobInstance = (JobEntity)job;
                jobInstance.setDuedate(null);
                jobInstance.setSuspensionState(SuspensionState.SUSPENDED.getStateCode());
            }
        }
        if (historyCleanupJobs.size() > 0) {
            return historyCleanupJobs.get(0);
        }
        return null;
    }

    private boolean willBeScheduled(CommandContext commandContext) {
        return this.immediatelyDue || HistoryCleanupHelper.isBatchWindowConfigured(commandContext);
    }
}

