/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class HistoryCleanupJobHandler
implements JobHandler<HistoryCleanupJobHandlerConfiguration> {
    public static final String TYPE = "history-cleanup";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(HistoryCleanupJobHandlerConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        List<JobEntity> jobs = commandContext.getJobManager().findJobsByConfiguration(this.getType(), configuration.toCanonicalString(), null, true);
        if (jobs.size() != 1) {
            throw new RuntimeException("No unique job can be identified by configuration: " + configuration.toCanonicalString());
        }
        JobEntity jobEntity = jobs.get(0);
        boolean rescheduled = false;
        if (configuration.isImmediatelyDue() || HistoryCleanupHelper.isBatchWindowConfigured(commandContext) && HistoryCleanupHelper.isWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext)) {
            HistoryCleanupBatch nextBatch = HistoryCleanupHelper.getNextBatch(commandContext, configuration);
            if (nextBatch.size() >= this.getBatchSizeThreshold(commandContext)) {
                nextBatch.performCleanup();
                commandContext.getJobManager().reschedule(jobEntity, ClockUtil.getCurrentTime());
                rescheduled = true;
                this.cancelCountEmptyRuns(configuration, jobEntity);
            } else {
                Date nextRunDate;
                if (nextBatch.size() > 0) {
                    nextBatch.performCleanup();
                }
                if (HistoryCleanupHelper.isWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext) && HistoryCleanupHelper.isWithinBatchWindow(nextRunDate = configuration.getNextRunWithDelay(ClockUtil.getCurrentTime()), commandContext)) {
                    commandContext.getJobManager().reschedule(jobEntity, nextRunDate);
                    rescheduled = true;
                    this.incrementCountEmptyRuns(configuration, jobEntity);
                }
            }
        }
        if (!rescheduled) {
            if (HistoryCleanupHelper.isBatchWindowConfigured(commandContext)) {
                this.rescheduleRegularCall(commandContext, jobEntity);
            } else {
                this.suspendJob(jobEntity);
            }
            this.cancelCountEmptyRuns(configuration, jobEntity);
        }
    }

    private void rescheduleRegularCall(CommandContext commandContext, JobEntity jobEntity) {
        commandContext.getJobManager().reschedule(jobEntity, HistoryCleanupHelper.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext));
    }

    private void suspendJob(JobEntity jobEntity) {
        jobEntity.setSuspensionState(SuspensionState.SUSPENDED.getStateCode());
    }

    private void incrementCountEmptyRuns(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
        configuration.setCountEmptyRuns(configuration.getCountEmptyRuns() + 1);
        jobEntity.setJobHandlerConfiguration(configuration);
    }

    private void cancelCountEmptyRuns(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
        configuration.setCountEmptyRuns(0);
        jobEntity.setJobHandlerConfiguration(configuration);
    }

    @Override
    public HistoryCleanupJobHandlerConfiguration newConfiguration(String canonicalString) {
        JSONObject jsonObject = new JSONObject(canonicalString);
        return HistoryCleanupJobHandlerConfiguration.fromJson(jsonObject);
    }

    @Override
    public void onDelete(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
    }

    public Integer getBatchSizeThreshold(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchThreshold();
    }
}

