/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;

public class ProcessDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<ProcessDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public void insertProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.getDbEntityManager().insert(processDefinition);
        this.createDefaultAuthorizations(processDefinition);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionByKey(String processDefinitionKey) {
        List processDefinitions = this.getDbEntityManager().selectList("selectLatestProcessDefinitionByKey", this.configureParameterizedQuery(processDefinitionKey));
        if (processDefinitions.isEmpty()) {
            return null;
        }
        if (processDefinitions.size() == 1) {
            return (ProcessDefinitionEntity)processDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForProcessDefinitionKeyException(processDefinitionKey);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (ProcessDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestProcessDefinitionByKeyWithoutTenantId", parameters);
        }
        return (ProcessDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestProcessDefinitionByKeyAndTenantId", parameters);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return this.getDbEntityManager().selectById(ProcessDefinitionEntity.class, processDefinitionId);
    }

    public List<ProcessDefinition> findProcessDefinitionsByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery, Page page) {
        this.configureProcessDefinitionQuery(processDefinitionQuery);
        return this.getDbEntityManager().selectList("selectProcessDefinitionsByQueryCriteria", processDefinitionQuery, page);
    }

    public long findProcessDefinitionCountByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery) {
        this.configureProcessDefinitionQuery(processDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectProcessDefinitionCountByQueryCriteria", processDefinitionQuery);
    }

    public ProcessDefinitionEntity findProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        return (ProcessDefinitionEntity)this.getDbEntityManager().selectOne("selectProcessDefinitionByDeploymentAndKey", parameters);
    }

    public ProcessDefinitionEntity findProcessDefinitionByKeyVersionAndTenantId(String processDefinitionKey, Integer processDefinitionVersion, String tenantId) {
        return this.findProcessDefinitionByKeyVersionOrVersionTag(processDefinitionKey, processDefinitionVersion, null, tenantId);
    }

    public ProcessDefinitionEntity findProcessDefinitionByKeyVersionTagAndTenantId(String processDefinitionKey, String processDefinitionVersionTag, String tenantId) {
        return this.findProcessDefinitionByKeyVersionOrVersionTag(processDefinitionKey, null, processDefinitionVersionTag, tenantId);
    }

    protected ProcessDefinitionEntity findProcessDefinitionByKeyVersionOrVersionTag(String processDefinitionKey, Integer processDefinitionVersion, String processDefinitionVersionTag, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (processDefinitionVersion != null) {
            parameters.put("processDefinitionVersion", processDefinitionVersion);
        } else if (processDefinitionVersionTag != null) {
            parameters.put("processDefinitionVersionTag", processDefinitionVersionTag);
        }
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("tenantId", tenantId);
        List results = this.getDbEntityManager().selectList("selectProcessDefinitionByKeyVersionAndTenantId", parameters);
        if (results.size() == 1) {
            return (ProcessDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            if (processDefinitionVersion != null) {
                throw LOG.toManyProcessDefinitionsException(results.size(), processDefinitionKey, "version", processDefinitionVersion.toString(), tenantId);
            }
            if (processDefinitionVersionTag != null) {
                throw LOG.toManyProcessDefinitionsException(results.size(), processDefinitionKey, "versionTag", processDefinitionVersionTag, tenantId);
            }
        }
        return null;
    }

    public List<ProcessDefinition> findProcessDefinitionsByKey(String processDefinitionKey) {
        ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl().processDefinitionKey(processDefinitionKey);
        return this.findProcessDefinitionsByQueryCriteria(processDefinitionQuery, null);
    }

    public List<ProcessDefinition> findProcessDefinitionsStartableByUser(String user) {
        return new ProcessDefinitionQueryImpl().startableByUser(user).list();
    }

    public String findPreviousProcessDefinitionId(String processDefinitionKey, Integer version, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", processDefinitionKey);
        params.put("version", version);
        params.put("tenantId", tenantId);
        return (String)this.getDbEntityManager().selectOne("selectPreviousProcessDefinitionId", params);
    }

    public List<ProcessDefinition> findProcessDefinitionsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectProcessDefinitionByDeploymentId", deploymentId);
    }

    public List<ProcessDefinition> findProcessDefinitionsByKeyIn(String ... keys) {
        return this.getDbEntityManager().selectList("selectProcessDefinitionByKeyIn", keys);
    }

    public List<ProcessDefinition> findDefinitionsByKeyAndTenantId(String processDefinitionKey, String tenantId, boolean isTenantIdSet) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isTenantIdSet", isTenantIdSet);
        parameters.put("tenantId", tenantId);
        return this.getDbEntityManager().selectList("selectProcessDefinitions", parameters);
    }

    public List<ProcessDefinition> findDefinitionsByIds(List<String> processDefinitionIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionIds", processDefinitionIds);
        parameters.put("isTenantIdSet", false);
        return this.getDbEntityManager().selectList("selectProcessDefinitions", parameters);
    }

    public void updateProcessDefinitionSuspensionStateById(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ProcessDefinitionEntity.class, "updateProcessDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateProcessDefinitionSuspensionStateByKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ProcessDefinitionEntity.class, "updateProcessDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateProcessDefinitionSuspensionStateByKeyAndTenantId(String processDefinitionKey, String tenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isTenantIdSet", true);
        parameters.put("tenantId", tenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ProcessDefinitionEntity.class, "updateProcessDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void cascadeDeleteProcessInstancesForProcessDefinition(String processDefinitionId, boolean skipCustomListeners) {
        this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted process definition", true, skipCustomListeners, false);
    }

    protected void cascadeDeleteHistoryForProcessDefinition(String processDefinitionId) {
        this.getHistoricIncidentManager().deleteHistoricIncidentsByProcessDefinitionId(processDefinitionId);
        this.getHistoricIdentityLinkManager().deleteHistoricIdentityLinksLogByProcessDefinitionId(processDefinitionId);
        this.getHistoricJobLogManager().deleteHistoricJobLogsByProcessDefinitionId(processDefinitionId);
    }

    protected void deleteTimerStartEventsForProcessDefinition(ProcessDefinition processDefinition) {
        List<JobEntity> timerStartJobs = this.getJobManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId());
        ProcessDefinitionEntity latestVersion = this.getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId());
        if (latestVersion != null && latestVersion.getId().equals(processDefinition.getId())) {
            for (Job job : timerStartJobs) {
                ((JobEntity)job).delete();
            }
        }
    }

    public void deleteSubscriptionsForProcessDefinition(String processDefinitionId) {
        ArrayList<EventSubscriptionEntity> eventSubscriptionsToRemove = new ArrayList<EventSubscriptionEntity>();
        List<EventSubscriptionEntity> messageEventSubscriptions = this.getEventSubscriptionManager().findEventSubscriptionsByConfiguration(EventType.MESSAGE.name(), processDefinitionId);
        eventSubscriptionsToRemove.addAll(messageEventSubscriptions);
        List<EventSubscriptionEntity> signalEventSubscriptions = this.getEventSubscriptionManager().findEventSubscriptionsByConfiguration(EventType.SIGNAL.name(), processDefinitionId);
        eventSubscriptionsToRemove.addAll(signalEventSubscriptions);
        List<EventSubscriptionEntity> conditionalEventSubscriptions = this.getEventSubscriptionManager().findEventSubscriptionsByConfiguration(EventType.CONDITONAL.name(), processDefinitionId);
        eventSubscriptionsToRemove.addAll(conditionalEventSubscriptions);
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptionsToRemove) {
            eventSubscriptionEntity.delete();
        }
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition, String processDefinitionId, boolean cascadeToHistory, boolean cascadeToInstances, boolean skipCustomListeners) {
        if (cascadeToHistory) {
            this.cascadeDeleteHistoryForProcessDefinition(processDefinitionId);
            if (cascadeToInstances) {
                this.cascadeDeleteProcessInstancesForProcessDefinition(processDefinitionId, skipCustomListeners);
            }
        } else {
            ProcessInstanceQueryImpl procInstQuery = new ProcessInstanceQueryImpl().processDefinitionId(processDefinitionId);
            long processInstanceCount = this.getProcessInstanceManager().findProcessInstanceCountByQueryCriteria(procInstQuery);
            if (processInstanceCount != 0L) {
                throw LOG.deleteProcessDefinitionWithProcessInstancesException(processDefinitionId, processInstanceCount);
            }
        }
        this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
        this.deleteTimerStartEventsForProcessDefinition(processDefinition);
        this.getDbEntityManager().delete(ProcessDefinitionEntity.class, "deleteProcessDefinitionsById", processDefinitionId);
        Context.getProcessEngineConfiguration().getDeploymentCache().removeProcessDefinition(processDefinitionId);
        this.deleteSubscriptionsForProcessDefinition(processDefinitionId);
        this.getJobDefinitionManager().deleteJobDefinitionsByProcessDefinitionId(processDefinition.getId());
    }

    protected void createDefaultAuthorizations(ProcessDefinition processDefinition) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newProcessDefinition(processDefinition);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureProcessDefinitionQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    @Override
    public ProcessDefinitionEntity findLatestDefinitionByKey(String key) {
        return this.findLatestProcessDefinitionByKey(key);
    }

    @Override
    public ProcessDefinitionEntity findLatestDefinitionById(String id) {
        return this.findLatestProcessDefinitionById(id);
    }

    @Override
    public ProcessDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(ProcessDefinitionEntity.class, definitionId);
    }

    @Override
    public ProcessDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.findLatestProcessDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    public ProcessDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        return this.findProcessDefinitionByKeyVersionAndTenantId(definitionKey, definitionVersion, tenantId);
    }

    @Override
    public ProcessDefinitionEntity findDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId) {
        return this.findProcessDefinitionByKeyVersionTagAndTenantId(definitionKey, definitionVersionTag, tenantId);
    }

    @Override
    public ProcessDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.findProcessDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }
}

