/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.StartProcessInstanceAtActivitiesCmd;
import org.camunda.bpm.engine.impl.cmd.StartProcessInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;

public class ProcessInstantiationBuilderImpl
implements ProcessInstantiationBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String businessKey;
    protected String caseInstanceId;
    protected String tenantId;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;
    protected ProcessInstanceModificationBuilderImpl modificationBuilder = new ProcessInstanceModificationBuilderImpl();

    protected ProcessInstantiationBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public ProcessInstantiationBuilder startBeforeActivity(String activityId) {
        this.modificationBuilder.startBeforeActivity(activityId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder startAfterActivity(String activityId) {
        this.modificationBuilder.startAfterActivity(activityId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder startTransition(String transitionId) {
        this.modificationBuilder.startTransition(transitionId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariable(String name, Object value) {
        this.modificationBuilder.setVariable(name, value);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariableLocal(String name, Object value) {
        this.modificationBuilder.setVariableLocal(name, value);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.modificationBuilder.setVariables((Map)variables);
        }
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariablesLocal(Map<String, Object> variables) {
        if (variables != null) {
            this.modificationBuilder.setVariablesLocal((Map)variables);
        }
        return this;
    }

    @Override
    public ProcessInstantiationBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstantiationBuilder caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public ProcessInstantiationBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstantiationBuilder processDefinitionTenantId(String tenantId) {
        this.processDefinitionTenantId = tenantId;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public ProcessInstantiationBuilder processDefinitionWithoutTenantId() {
        this.processDefinitionTenantId = null;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public ProcessInstance execute() {
        return this.execute(false, false);
    }

    @Override
    public ProcessInstance execute(boolean skipCustomListeners, boolean skipIoMappings) {
        return this.executeWithVariablesInReturn(skipCustomListeners, skipIoMappings);
    }

    @Override
    public ProcessInstanceWithVariables executeWithVariablesInReturn() {
        return this.executeWithVariablesInReturn(false, false);
    }

    @Override
    public ProcessInstanceWithVariables executeWithVariablesInReturn(boolean skipCustomListeners, boolean skipIoMappings) {
        Command<ProcessInstanceWithVariables> command;
        EnsureUtil.ensureOnlyOneNotNull("either process definition id or key must be set", this.processDefinitionId, this.processDefinitionKey);
        if (this.isProcessDefinitionTenantIdSet && this.processDefinitionId != null) {
            throw LOG.exceptionStartProcessInstanceByIdAndTenantId();
        }
        if (this.modificationBuilder.getModificationOperations().isEmpty()) {
            if (skipCustomListeners || skipIoMappings) {
                throw LOG.exceptionStartProcessInstanceAtStartActivityAndSkipListenersOrMapping();
            }
            command = new StartProcessInstanceCmd(this);
        } else {
            this.modificationBuilder.setSkipCustomListeners(skipCustomListeners);
            this.modificationBuilder.setSkipIoMappings(skipIoMappings);
            command = new StartProcessInstanceAtActivitiesCmd(this);
        }
        return this.commandExecutor.execute(command);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public ProcessInstanceModificationBuilderImpl getModificationBuilder() {
        return this.modificationBuilder;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.modificationBuilder.getProcessVariables();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public boolean isProcessDefinitionTenantIdSet() {
        return this.isProcessDefinitionTenantIdSet;
    }

    public void setModificationBuilder(ProcessInstanceModificationBuilderImpl modificationBuilder) {
        this.modificationBuilder = modificationBuilder;
    }

    public static ProcessInstantiationBuilder createProcessInstanceById(CommandExecutor commandExecutor, String processDefinitionId) {
        ProcessInstantiationBuilderImpl builder = new ProcessInstantiationBuilderImpl(commandExecutor);
        builder.processDefinitionId = processDefinitionId;
        return builder;
    }

    public static ProcessInstantiationBuilder createProcessInstanceByKey(CommandExecutor commandExecutor, String processDefinitionKey) {
        ProcessInstantiationBuilderImpl builder = new ProcessInstantiationBuilderImpl(commandExecutor);
        builder.processDefinitionKey = processDefinitionKey;
        return builder;
    }
}

