/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cmd.AbstractDeleteProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeleteProcessDefinitionsByKeyCmd
extends AbstractDeleteProcessDefinitionCmd {
    private static final long serialVersionUID = 1L;
    private final String processDefinitionKey;
    private final String tenantId;
    private final boolean isTenantIdSet;

    public DeleteProcessDefinitionsByKeyCmd(String processDefinitionKey, boolean cascade, boolean skipCustomListeners, String tenantId, boolean isTenantIdSet) {
        this.processDefinitionKey = processDefinitionKey;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
        this.tenantId = tenantId;
        this.isTenantIdSet = isTenantIdSet;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)this.processDefinitionKey);
        List<ProcessDefinition> processDefinitions = commandContext.getProcessDefinitionManager().findDefinitionsByKeyAndTenantId(this.processDefinitionKey, this.tenantId, this.isTenantIdSet);
        EnsureUtil.ensureNotEmpty(NotFoundException.class, "No process definition found with key '" + this.processDefinitionKey + "'", "processDefinitions", processDefinitions);
        for (ProcessDefinition processDefinition : processDefinitions) {
            String processDefinitionId = processDefinition.getId();
            this.deleteProcessDefinitionCmd(commandContext, processDefinitionId, this.cascade, this.skipCustomListeners);
        }
        return null;
    }
}

