/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public abstract class HistoryCleanupHelper {
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS = new SimpleDateFormat("yyyy-MM-ddHH:mm");
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE = new SimpleDateFormat("yyyy-MM-ddHH:mmZ");
    private static final SimpleDateFormat DATE_FORMAT_WITHOUT_TIME = new SimpleDateFormat("yyyy-MM-dd");

    public static boolean isWithinBatchWindow(Date date, ProcessEngineConfigurationImpl configuration) {
        if (configuration.getBatchWindowManager().isBatchWindowConfigured(configuration)) {
            BatchWindow batchWindow = configuration.getBatchWindowManager().getCurrentOrNextBatchWindow(date, configuration);
            if (batchWindow == null) {
                return false;
            }
            return batchWindow.isWithin(date);
        }
        return false;
    }

    public static synchronized Date parseTimeConfiguration(String time) throws ParseException {
        String today = DATE_FORMAT_WITHOUT_TIME.format(ClockUtil.getCurrentTime());
        try {
            return TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE.parse(today + time);
        }
        catch (ParseException ex) {
            return TIME_FORMAT_WITHOUT_SECONDS.parse(today + time);
        }
    }

    private static Integer getHistoryCleanupBatchSize(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }

    public static HistoryCleanupBatch getNextBatch(CommandContext commandContext, HistoryCleanupJobHandlerConfiguration configuration) {
        List<String> historicBatchIds;
        List<String> historicCaseInstanceIds;
        List<String> historicDecisionInstanceIds;
        Integer batchSize = HistoryCleanupHelper.getHistoryCleanupBatchSize(commandContext);
        HistoryCleanupBatch historyCleanupBatch = new HistoryCleanupBatch();
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        List<String> historicProcessInstanceIds = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanup(batchSize, configuration.getMinuteFrom(), configuration.getMinuteTo());
        if (historicProcessInstanceIds.size() > 0) {
            historyCleanupBatch.setHistoricProcessInstanceIds(historicProcessInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isDmnEnabled() && (historicDecisionInstanceIds = commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceIdsForCleanup(batchSize - historyCleanupBatch.size(), configuration.getMinuteFrom(), configuration.getMinuteTo())).size() > 0) {
            historyCleanupBatch.setHistoricDecisionInstanceIds(historicDecisionInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isCmmnEnabled() && (historicCaseInstanceIds = commandContext.getHistoricCaseInstanceManager().findHistoricCaseInstanceIdsForCleanup(batchSize - historyCleanupBatch.size(), configuration.getMinuteFrom(), configuration.getMinuteTo())).size() > 0) {
            historyCleanupBatch.setHistoricCaseInstanceIds(historicCaseInstanceIds);
        }
        Map<String, Integer> batchOperationsForHistoryCleanup = processEngineConfiguration.getParsedBatchOperationsForHistoryCleanup();
        if (historyCleanupBatch.size() < batchSize && batchOperationsForHistoryCleanup != null && !batchOperationsForHistoryCleanup.isEmpty() && (historicBatchIds = commandContext.getHistoricBatchManager().findHistoricBatchIdsForCleanup(batchSize - historyCleanupBatch.size(), batchOperationsForHistoryCleanup, configuration.getMinuteFrom(), configuration.getMinuteTo())).size() > 0) {
            historyCleanupBatch.setHistoricBatchIds(historicBatchIds);
        }
        return historyCleanupBatch;
    }

    public static int[][] listMinuteChunks(int numberOfChunks) {
        int[][] minuteChunks = new int[numberOfChunks][2];
        int chunkLength = 60 / numberOfChunks;
        for (int i = 0; i < numberOfChunks; ++i) {
            minuteChunks[i][0] = chunkLength * i;
            minuteChunks[i][1] = chunkLength * (i + 1) - 1;
        }
        minuteChunks[numberOfChunks - 1][1] = 59;
        return minuteChunks;
    }

    public static boolean isBatchWindowConfigured(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getBatchWindowManager().isBatchWindowConfigured(commandContext.getProcessEngineConfiguration());
    }
}

