/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MetricIntervalEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.MetricIntervalValue;

public class MeterLogManager
extends AbstractManager {
    public static final String SELECT_METER_INTERVAL = "selectMeterLogAggregatedByTimeInterval";
    public static final String SELECT_METER_SUM = "selectMeterLogSum";
    public static final String DELETE_ALL_METER = "deleteAllMeterLogEntries";
    public static final String DELETE_ALL_METER_BY_TIMESTAMP_AND_REPORTER = "deleteMeterLogEntriesByTimestampAndReporter";

    public void insert(MeterLogEntity meterLogEntity) {
        this.getDbEntityManager().insert(meterLogEntity);
    }

    public Long executeSelectSum(MetricsQueryImpl query) {
        Meter meter;
        Long result = (Long)this.getDbEntityManager().selectOne(SELECT_METER_SUM, query);
        result = result != null ? result : 0L;
        if (this.shouldAddCurrentUnloggedCount(query) && (meter = Context.getProcessEngineConfiguration().getMetricsRegistry().getMeterByName(query.getName())) != null) {
            result = result + meter.get();
        }
        return result;
    }

    public List<MetricIntervalValue> executeSelectInterval(MetricsQueryImpl query) {
        List intervalResult = this.getDbEntityManager().selectList(SELECT_METER_INTERVAL, query);
        intervalResult = intervalResult != null ? intervalResult : new ArrayList();
        String reporterId = Context.getProcessEngineConfiguration().getDbMetricsReporter().getMetricsCollectionTask().getReporter();
        if (!intervalResult.isEmpty() && this.isEndTimeAfterLastReportInterval(query) && reporterId != null) {
            Map<String, Meter> metrics = Context.getProcessEngineConfiguration().getMetricsRegistry().getMeters();
            String queryName = query.getName();
            if (queryName != null) {
                MetricIntervalEntity intervalEntity = (MetricIntervalEntity)intervalResult.get(0);
                long entityValue = intervalEntity.getValue();
                if (metrics.get(queryName) != null) {
                    entityValue += metrics.get(queryName).get();
                }
                intervalEntity.setValue(entityValue);
            } else {
                Set<String> metricNames = metrics.keySet();
                Date lastIntervalTimestamp = ((MetricIntervalValue)intervalResult.get(0)).getTimestamp();
                for (String metricName : metricNames) {
                    MetricIntervalEntity entity = new MetricIntervalEntity(lastIntervalTimestamp, metricName, reporterId);
                    int idx = intervalResult.indexOf(entity);
                    if (idx < 0) continue;
                    MetricIntervalEntity intervalValue = (MetricIntervalEntity)intervalResult.get(idx);
                    intervalValue.setValue(intervalValue.getValue() + metrics.get(metricName).get());
                }
            }
        }
        return intervalResult;
    }

    protected boolean isEndTimeAfterLastReportInterval(MetricsQueryImpl query) {
        long reportingIntervalInSeconds = Context.getProcessEngineConfiguration().getDbMetricsReporter().getReportingIntervalInSeconds();
        return query.getEndDate() == null || query.getEndDateMilliseconds() >= ClockUtil.getCurrentTime().getTime() - 1000L * reportingIntervalInSeconds;
    }

    protected boolean shouldAddCurrentUnloggedCount(MetricsQueryImpl query) {
        return query.getName() != null && this.isEndTimeAfterLastReportInterval(query);
    }

    public void deleteAll() {
        this.getDbEntityManager().delete(MeterLogEntity.class, DELETE_ALL_METER, null);
    }

    public void deleteByTimestampAndReporter(Date timestamp, String reporter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (timestamp != null) {
            parameters.put("milliseconds", timestamp.getTime());
        }
        parameters.put("reporter", reporter);
        this.getDbEntityManager().delete(MeterLogEntity.class, DELETE_ALL_METER_BY_TIMESTAMP_AND_REPORTER, parameters);
    }
}

