/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.identity.TestResource;

public class AuthorizationServiceWithEnabledAuthorizationTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testAuthorizationCheckEmptyDb() {
        TestResource resource1 = new TestResource("resource1", 100);
        TestResource resource2 = new TestResource("resource2", 101);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)Permissions.CREATE, (Resource)resource2));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.ALL, (Resource)resource1, "someId"));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)Permissions.CREATE, (Resource)resource2, "someId"));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.DELETE, (Resource)resource1, "someOtherId"));
    }

    public void testUserOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(2);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.DELETE, (Resource)resource1));
    }

    public void testGroupOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.DELETE, (Resource)resource1));
    }

    public void testUserOverrideGlobalRevokeAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.removePermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(1);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)Permissions.DELETE, (Resource)resource1));
    }

    public void testNullAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized(null, null, (Permission)Permissions.UPDATE, (Resource)resource1));
    }

    public void testUserOverrideGroupOverrideGlobalAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        Authorization userGrant = this.authorizationService.createNewAuthorization(1);
        userGrant.setUserId("jonny");
        userGrant.setResource((Resource)resource1);
        userGrant.setResourceId("*");
        userGrant.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(userGrant);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)Permissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)Permissions.READ, (Resource)resource1));
    }

    public void testEnabledAuthorizationCheck() {
        TestResource resource1 = new TestResource("resource1", 100);
        boolean isAuthorized = this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.UPDATE, (Resource)resource1);
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)isAuthorized);
    }

    protected void cleanupAfterTest() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

