/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.AuthenticationException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.Account;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IdentityServiceTest {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Test
    public void testIsReadOnly() {
        Assert.assertFalse((boolean)this.identityService.isReadOnly());
    }

    @Test
    public void testUserInfo() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        Assert.assertEquals((Object)"myvalue", (Object)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue2");
        Assert.assertEquals((Object)"myvalue2", (Object)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUserInfo("testuser", "myinfo");
        Assert.assertNull((Object)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testUserAccount() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", null);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        Assert.assertEquals((Object)"google", (Object)googleAccount.getName());
        Assert.assertEquals((Object)"mygoogleusername", (Object)googleAccount.getUsername());
        Assert.assertEquals((Object)"mygooglepwd", (Object)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername2", "mygooglepwd2", null);
        googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        Assert.assertEquals((Object)"google", (Object)googleAccount.getName());
        Assert.assertEquals((Object)"mygoogleusername2", (Object)googleAccount.getUsername());
        Assert.assertEquals((Object)"mygooglepwd2", (Object)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "alfresco", "myalfrescousername", "myalfrescopwd", null);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        this.identityService.setUserInfo("testuser", "myinfo2", "myvalue2");
        ArrayList<String> expectedUserAccountNames = new ArrayList<String>();
        expectedUserAccountNames.add("google");
        expectedUserAccountNames.add("alfresco");
        List userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUserAccount("testuser", "google");
        expectedUserAccountNames.remove("google");
        userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUser(user.getId());
    }

    private void assertListElementsMatch(List<String> list1, List<String> list2) {
        if (list1 != null) {
            Assert.assertNotNull(list2);
            Assert.assertEquals((long)list1.size(), (long)list2.size());
            for (String value : list1) {
                Assert.assertTrue((boolean)list2.contains(value));
            }
        } else {
            Assert.assertNull(list2);
        }
    }

    @Test
    public void testUserAccountDetails() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        HashMap<String, String> accountDetails = new HashMap<String, String>();
        accountDetails.put("server", "localhost");
        accountDetails.put("port", "35");
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", accountDetails);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        Assert.assertEquals(accountDetails, (Object)googleAccount.getDetails());
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testCreateExistingUser() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        User secondUser = this.identityService.newUser("testuser");
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.saveUser(secondUser);
    }

    @Test
    public void testUpdateUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        user.setEmail("updated@alfresco.com");
        user.setFirstName("Jane");
        user.setLastName("Donnel");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        Assert.assertEquals((Object)"Jane", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Donnel", (Object)user.getLastName());
        Assert.assertEquals((Object)"updated@alfresco.com", (Object)user.getEmail());
        Assert.assertTrue((boolean)this.identityService.checkPassword("johndoe", "s3cret"));
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testUserPicture() {
        User user = this.identityService.newUser("johndoe");
        this.identityService.saveUser(user);
        String userId = user.getId();
        Picture picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        picture = this.identityService.getUserPicture(userId);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        Assert.assertTrue((String)"byte arrays differ", (boolean)Arrays.equals("niceface".getBytes(), picture.getBytes()));
        Assert.assertEquals((Object)"image/string", (Object)picture.getMimeType());
        this.identityService.deleteUserPicture("johndoe");
        this.identityService.deleteUserPicture("someone-else-we-dont-know");
        picture = this.identityService.getUserPicture("johndoe");
        Assert.assertNull((Object)picture);
        picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testUpdateGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        group.setName("Updated");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        Assert.assertEquals((Object)"Updated", (Object)group.getName());
        this.identityService.deleteGroup(group.getId());
    }

    @Test
    public void findUserByUnexistingId() {
        User user = (User)this.identityService.createUserQuery().userId("unexistinguser").singleResult();
        Assert.assertNull((Object)user);
    }

    @Test
    public void findGroupByUnexistingId() {
        Group group = (Group)this.identityService.createGroupQuery().groupId("unexistinggroup").singleResult();
        Assert.assertNull((Object)group);
    }

    @Test
    public void testCreateMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createMembership(johndoe.getId(), "unexistinggroup");
    }

    @Test
    public void testCreateMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createMembership("unexistinguser", sales.getId());
    }

    @Test
    public void testCreateMembershipAlreadyExisting() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
    }

    @Test
    public void testSaveGroupNullArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("group is null");
        this.identityService.saveGroup(null);
    }

    @Test
    public void testSaveUserNullArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("user is null");
        this.identityService.saveUser(null);
    }

    @Test
    public void testFindGroupByIdNullArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("id is null");
        this.identityService.createGroupQuery().groupId(null).singleResult();
    }

    @Test
    public void testCreateMembershipNullUserArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("userId is null");
        this.identityService.createMembership(null, "group");
    }

    @Test
    public void testCreateMembershipNullGroupArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("groupId is null");
        this.identityService.createMembership("userId", null);
    }

    @Test
    public void testFindGroupsByUserIdNullArguments() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("userId is null");
        this.identityService.createGroupQuery().groupMember(null).singleResult();
    }

    @Test
    public void testFindUsersByGroupUnexistingGroup() {
        List users = this.identityService.createUserQuery().memberOfGroup("unexistinggroup").list();
        Assert.assertNotNull((Object)users);
        Assert.assertTrue((boolean)users.isEmpty());
    }

    @Test
    public void testDeleteGroupNullArguments() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("groupId is null");
        this.identityService.deleteGroup(null);
    }

    @Test
    public void testDeleteMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        List groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"sales", (Object)((Group)groups.get(0)).getId());
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        Assert.assertTrue((groups.size() == 0 ? 1 : 0) != 0);
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testDeleteMembershipWhenUserIsNoMember() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testDeleteMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), "unexistinggroup");
        this.identityService.deleteUser(johndoe.getId());
    }

    @Test
    public void testDeleteMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        this.identityService.deleteMembership("unexistinguser", sales.getId());
        this.identityService.deleteGroup(sales.getId());
    }

    @Test
    public void testDeleteMemberschipNullUserArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("userId is null");
        this.identityService.deleteMembership(null, "group");
    }

    @Test
    public void testDeleteMemberschipNullGroupArgument() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("groupId is null");
        this.identityService.deleteMembership("user", null);
    }

    @Test
    public void testDeleteUserNullArguments() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("userId is null");
        this.identityService.deleteUser(null);
    }

    @Test
    public void testDeleteUserUnexistingUserId() {
        this.identityService.deleteUser("unexistinguser");
    }

    @Test
    public void testCheckPassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        Assert.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        Assert.assertFalse((boolean)this.identityService.checkPassword(user.getId(), "wrong"));
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testUpdatePassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        Assert.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        user.setPassword("new-password");
        this.identityService.saveUser(user);
        Assert.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "new-password"));
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testCheckPasswordNullSafe() {
        Assert.assertFalse((boolean)this.identityService.checkPassword("userId", null));
        Assert.assertFalse((boolean)this.identityService.checkPassword(null, "passwd"));
        Assert.assertFalse((boolean)this.identityService.checkPassword(null, null));
    }

    @Test
    public void testUserOptimisticLockingException() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        this.thrown.expect(OptimisticLockingException.class);
        user2.setFirstName("name two");
        this.identityService.saveUser(user2);
    }

    @Test
    public void testGroupOptimisticLockingException() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        Group group1 = (Group)this.identityService.createGroupQuery().singleResult();
        Group group2 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("name one");
        this.identityService.saveGroup(group1);
        this.thrown.expect(OptimisticLockingException.class);
        group2.setName("name two");
        this.identityService.saveGroup(group2);
    }

    @Test
    public void testSaveUserWithGenericResourceId() {
        User user = this.identityService.newUser("*");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("has an invalid id: id cannot be *. * is a reserved identifier.");
        this.identityService.saveUser(user);
    }

    @Test
    public void testSaveGroupWithGenericResourceId() {
        Group group = this.identityService.newGroup("*");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("has an invalid id: id cannot be *. * is a reserved identifier.");
        this.identityService.saveGroup(group);
    }

    @Test
    public void testSetAuthenticatedIdToGenericId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid user id provided: id cannot be *. * is a reserved identifier.");
        this.identityService.setAuthenticatedUserId("*");
    }

    @Test
    public void testSetAuthenticationUserIdToGenericId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("invalid group id provided: id cannot be *. * is a reserved identifier.");
        this.identityService.setAuthentication("aUserId", Arrays.asList("*"));
    }

    @Test
    public void testSetAuthenticatedTenantIdToGenericId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("invalid tenant id provided: id cannot be *. * is a reserved identifier.");
        this.identityService.setAuthentication(null, null, Arrays.asList("*"));
    }

    @Test
    public void testSetAuthenticatedUserId() {
        this.identityService.setAuthenticatedUserId("john");
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        Assert.assertNotNull((Object)currentAuthentication);
        Assert.assertEquals((Object)"john", (Object)currentAuthentication.getUserId());
        Assert.assertNull((Object)currentAuthentication.getGroupIds());
        Assert.assertNull((Object)currentAuthentication.getTenantIds());
    }

    @Test
    public void testSetAuthenticatedUserAndGroups() {
        List<String> groups = Arrays.asList("sales", "development");
        this.identityService.setAuthentication("john", groups);
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        Assert.assertNotNull((Object)currentAuthentication);
        Assert.assertEquals((Object)"john", (Object)currentAuthentication.getUserId());
        Assert.assertEquals(groups, (Object)currentAuthentication.getGroupIds());
        Assert.assertNull((Object)currentAuthentication.getTenantIds());
    }

    @Test
    public void testSetAuthenticatedUserGroupsAndTenants() {
        List<String> groups = Arrays.asList("sales", "development");
        List<String> tenants = Arrays.asList("tenant1", "tenant2");
        this.identityService.setAuthentication("john", groups, tenants);
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        Assert.assertNotNull((Object)currentAuthentication);
        Assert.assertEquals((Object)"john", (Object)currentAuthentication.getUserId());
        Assert.assertEquals(groups, (Object)currentAuthentication.getGroupIds());
        Assert.assertEquals(tenants, (Object)currentAuthentication.getTenantIds());
    }

    @Test
    public void testAuthentication() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Assert.assertTrue((boolean)this.identityService.checkPassword("johndoe", "xxx"));
        Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testUsuccessfulAttemptsResultInException() throws ParseException {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        this.thrown.expect(AuthenticationException.class);
        this.thrown.expectMessage("The user with id 'johndoe' is permanently locked. Please contact your admin to unlock the account.");
        Date now = sdf.parse("2000-01-24T13:00:00");
        ClockUtil.setCurrentTime((Date)now);
        for (int i = 0; i <= 11; ++i) {
            Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
            now = DateUtils.addMinutes((Date)now, (int)1);
            ClockUtil.setCurrentTime((Date)now);
        }
    }

    @Test
    public void testSuccessfulLoginAfterFailureAndDelay() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Date now = null;
        now = ClockUtil.getCurrentTime();
        Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)now, (int)30));
        Assert.assertTrue((boolean)this.identityService.checkPassword("johndoe", "xxx"));
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testSuccessfulLoginAfterFailureWithoutDelay() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Date now = ClockUtil.getCurrentTime();
        Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        try {
            Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "xxx"));
            Assert.fail((String)"expected exception");
        }
        catch (AuthenticationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The user with id 'johndoe' is locked."));
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)now, (int)30));
        Assert.assertTrue((boolean)this.identityService.checkPassword("johndoe", "xxx"));
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testUnsuccessfulLoginAfterFailureWithoutDelay() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        Date now = null;
        now = ClockUtil.getCurrentTime();
        Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)now, (int)1));
        try {
            Assert.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
            Assert.fail((String)"expected exception");
        }
        catch (AuthenticationException e) {
            Date expectedLockExpitation = DateUtils.addSeconds((Date)now, (int)3);
            Assert.assertTrue((boolean)e.getMessage().contains("The lock will expire at " + expectedLockExpitation));
        }
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testFindGroupsByUserAndType() {
        Group sales = this.identityService.newGroup("sales");
        sales.setType("hierarchy");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        development.setType("hierarchy");
        this.identityService.saveGroup(development);
        Group admin = this.identityService.newGroup("admin");
        admin.setType("security-role");
        this.identityService.saveGroup(admin);
        Group user = this.identityService.newGroup("user");
        user.setType("security-role");
        this.identityService.saveGroup(user);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("johndoe", "user");
        this.identityService.createMembership("johndoe", "admin");
        this.identityService.createMembership("joesmoe", "user");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").groupType("security-role").list();
        Set<String> groupIds = this.getGroupIds(groups);
        HashSet<String> expectedGroupIds = new HashSet<String>();
        expectedGroupIds.add("user");
        expectedGroupIds.add("admin");
        Assert.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").groupType("security-role").list();
        groupIds = this.getGroupIds(groups);
        expectedGroupIds = new HashSet();
        expectedGroupIds.add("user");
        Assert.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("jackblack").groupType("security-role").list();
        Assert.assertTrue((boolean)groups.isEmpty());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteGroup("admin");
        this.identityService.deleteGroup("user");
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("jackblack");
    }

    @Test
    public void testUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)user.getId());
        Assert.assertEquals((Object)"John", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)user.getLastName());
        Assert.assertEquals((Object)"johndoe@alfresco.com", (Object)user.getEmail());
        this.identityService.deleteUser("johndoe");
    }

    @Test
    public void testGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales division");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        Assert.assertEquals((Object)"sales", (Object)group.getId());
        Assert.assertEquals((Object)"Sales division", (Object)group.getName());
        this.identityService.deleteGroup("sales");
    }

    @Test
    public void testMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        this.identityService.saveGroup(development);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("joesmoe", "sales");
        this.identityService.createMembership("joesmoe", "development");
        this.identityService.createMembership("jackblack", "development");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").list();
        Assert.assertEquals((Object)this.createStringSet("sales"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").list();
        Assert.assertEquals((Object)this.createStringSet("sales", "development"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("jackblack").list();
        Assert.assertEquals((Object)this.createStringSet("development"), this.getGroupIds(groups));
        List users = this.identityService.createUserQuery().memberOfGroup("sales").list();
        Assert.assertEquals((Object)this.createStringSet("johndoe", "joesmoe"), this.getUserIds(users));
        users = this.identityService.createUserQuery().memberOfGroup("development").list();
        Assert.assertEquals((Object)this.createStringSet("joesmoe", "jackblack"), this.getUserIds(users));
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteUser("jackblack");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("johndoe");
    }

    private Object createStringSet(String ... strings) {
        HashSet<String> stringSet = new HashSet<String>();
        for (String string : strings) {
            stringSet.add(string);
        }
        return stringSet;
    }

    protected Set<String> getGroupIds(List<Group> groups) {
        HashSet<String> groupIds = new HashSet<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected Set<String> getUserIds(List<User> users) {
        HashSet<String> userIds = new HashSet<String>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }
}

