/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="full")
public class ProcessInstanceModificationHistoryTest
extends PluggableProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_ASYNC_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartBeforeWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"procInstVar", (String)procInstVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localVariable);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"localVar", (String)localVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1", "task2");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    public void testStartBeforeAsyncWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"procInstVar", (String)procInstVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localVariable);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"localVar", (String)localVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.completeTasksInOrder("task2");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testStartBeforeScopeWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"procInstVar", (String)procInstVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getActivityInstances("subProcess")[0].getId(), (String)localVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"localVar", (String)localVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartTransitionWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"procInstVar", (String)procInstVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)procInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localVariable);
        ProcessInstanceModificationHistoryTest.assertEquals((String)updatedTree.getId(), (String)procInstVariable.getActivityInstanceId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"localVar", (String)localVariable.getName());
        ProcessInstanceModificationHistoryTest.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)localInstanceVarDetail);
        ProcessInstanceModificationHistoryTest.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1", "task1");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCancelTaskShouldCancelProcessInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("theTask").execute(true, false);
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)instance);
        ProcessInstanceModificationHistoryTest.assertEquals((String)processInstanceId, (String)instance.getId());
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)instance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testSkipCustomListenerEnsureHistoryWritten() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("exclusiveGateway").getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task2")).execute(true, false);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        HistoricActivityInstance instance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task2").singleResult();
        ProcessInstanceModificationHistoryTest.assertNotNull((Object)instance);
        ProcessInstanceModificationHistoryTest.assertEquals((String)task.getId(), (String)instance.getTaskId());
        ProcessInstanceModificationHistoryTest.assertEquals((String)"kermit", (String)instance.getAssignee());
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstanceModificationHistoryTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

