/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessInstanceModificationSubProcessTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    private RuntimeService runtimeService;
    private RepositoryService repositoryService;
    private TaskService taskService;

    @Before
    public void init() {
        this.repositoryService = this.rule.getRepositoryService();
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    public void shouldCompleteParentProcess() {
        BpmnModelInstance parentProcessInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().callActivity("callActivity").calledElement("subprocess")).endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskName("userTask").singleResult());
        ProcessInstance subprocess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        Assert.assertNotNull((Object)subprocess);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(subprocess.getProcessInstanceId()).cancelAllForActivity("userTask").startAfterActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldContinueParentProcess() {
        BpmnModelInstance parentProcessInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().callActivity("callActivity").calledElement("subprocess")).userTask().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        ProcessInstance parentPI = this.runtimeService.startProcessInstanceByKey("parentProcess");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskName("userTask").singleResult());
        ProcessInstance subprocess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        Assert.assertNotNull((Object)subprocess);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(subprocess.getProcessInstanceId()).cancelAllForActivity("userTask").startAfterActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)1L));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getProcessInstanceId(), (Matcher)Matchers.is((Object)parentPI.getId()));
    }

    @Test
    public void shouldCompleteParentProcessWithParallelGateway() {
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().parallelGateway().serviceTask("doNothingServiceTask").camundaExpression("${true}")).moveToLastGateway().callActivity("callActivity").calledElement("subprocess")).parallelGateway("mergingParallelGateway").endEvent().done();
        BpmnModelInstance parentProcessInstance = ModifiableBpmnModelInstance.modify(modelInstance).flowNodeBuilder("doNothingServiceTask").connectTo("mergingParallelGateway").done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        ProcessInstance subprocess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        Assert.assertNotNull((Object)subprocess);
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskName("userTask").singleResult());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(subprocess.getProcessInstanceId()).cancelAllForActivity("userTask").startAfterActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldContinueParentProcessWithParallelGateway() {
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().parallelGateway().serviceTask("doNothingServiceTask").camundaExpression("${true}")).moveToLastGateway().callActivity("callActivity").calledElement("subprocess")).parallelGateway("mergingParallelGateway").userTask().endEvent().done();
        BpmnModelInstance parentProcessInstance = ModifiableBpmnModelInstance.modify(modelInstance).flowNodeBuilder("doNothingServiceTask").connectTo("mergingParallelGateway").done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        ProcessInstance parentPI = this.runtimeService.startProcessInstanceByKey("parentProcess");
        ProcessInstance subprocess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        Assert.assertNotNull((Object)subprocess);
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskName("userTask").singleResult());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(subprocess.getProcessInstanceId()).cancelAllForActivity("userTask").startAfterActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)1L));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getProcessInstanceId(), (Matcher)Matchers.is((Object)parentPI.getId()));
    }

    @Test
    public void shouldCompleteParentProcessWithMultiInstance() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().callActivity("callActivity").calledElement("subprocess")).multiInstance().cardinality("3")).multiInstanceDone().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldContinueParentProcessWithMultiInstance() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().callActivity("callActivity").calledElement("subprocess")).multiInstance().cardinality("3")).multiInstanceDone().userTask().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        ProcessInstance parentPI = this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)1L));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getProcessInstanceId(), (Matcher)Matchers.is((Object)parentPI.getId()));
    }

    @Test
    public void shouldCompleteParentProcessWithMultiInstanceInsideEmbeddedSubProcess() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().subProcess().embeddedSubProcess().startEvent().callActivity("callActivity").calledElement("subprocess")).multiInstance().cardinality("3")).multiInstanceDone().endEvent().subProcessDone().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldContinueParentProcessWithMultiInstanceInsideEmbeddedSubProcess() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().subProcess().embeddedSubProcess().startEvent().callActivity("callActivity").calledElement("subprocess")).multiInstance().cardinality("3")).multiInstanceDone().endEvent().subProcessDone().userTask().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        ProcessInstance parentPI = this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)1L));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getProcessInstanceId(), (Matcher)Matchers.is((Object)parentPI.getId()));
    }

    @Test
    public void shouldCompleteParentProcessWithMultiInstanceEmbeddedSubProcess() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().subProcess().embeddedSubProcess().startEvent().callActivity("callActivity").calledElement("subprocess")).endEvent().subProcessDone().multiInstance().cardinality("3")).multiInstanceDone().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldContinueParentProcessWithMultiInstanceEmbeddedSubProcess() {
        BpmnModelInstance parentProcessInstance = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().subProcess().embeddedSubProcess().startEvent().callActivity("callActivity").calledElement("subprocess")).endEvent().subProcessDone().multiInstance().cardinality("3")).multiInstanceDone().userTask().endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        String subprocessPrDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult()).getId();
        ProcessInstance parentPI = this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subprocesses = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subprocesses.size());
        ((ModificationBuilder)this.runtimeService.createModification(subprocessPrDefId).cancelAllForActivity("userTask").startAfterActivity("userTask")).processInstanceIds(this.collectIds(subprocesses)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)1L));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getProcessInstanceId(), (Matcher)Matchers.is((Object)parentPI.getId()));
    }

    @Test
    public void shouldCancelParentProcessWithMultiInstanceCallActivity() {
        BpmnModelInstance parentProcess = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().callActivity("callActivity").calledElement("subprocess")).multiInstance().cardinality("3")).multiInstanceDone().endEvent().userTask().endEvent().done();
        BpmnModelInstance subProcess = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcess, subProcess);
        ProcessDefinition subProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult();
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subProcessInstances.size());
        ((ModificationBuilder)this.runtimeService.createModification(subProcessDefinition.getId()).startAfterActivity("userTask")).cancelAllForActivity("userTask").processInstanceIds(this.collectIds(subProcessInstances)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldCancelParentProcessWithCallActivityInMultiInstanceEmbeddedSubprocess() {
        BpmnModelInstance parentProcess = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().subProcess().embeddedSubProcess().startEvent().callActivity("callActivity").calledElement("subprocess")).endEvent().subProcessDone().multiInstance().cardinality("3")).multiInstanceDone().endEvent().userTask().endEvent().done();
        BpmnModelInstance subProcess = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcess, subProcess);
        ProcessDefinition subProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("subprocess").singleResult();
        this.runtimeService.startProcessInstanceByKey("parentProcess");
        List subProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").list();
        Assert.assertEquals((long)3L, (long)subProcessInstances.size());
        ((ModificationBuilder)this.runtimeService.createModification(subProcessDefinition.getId()).startAfterActivity("userTask")).cancelAllForActivity("userTask").processInstanceIds(this.collectIds(subProcessInstances)).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldCancelConcurrentExecutionInCallingProcess() {
        BpmnModelInstance parentProcessInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"parentProcess").startEvent().parallelGateway("split").callActivity("callActivity").calledElement("subprocess")).endEvent().moveToLastGateway().userTask("parentUserTask").endEvent().done();
        BpmnModelInstance subprocessInstance = Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("childUserTask").endEvent("subEnd").done();
        this.testHelper.deploy(parentProcessInstance, subprocessInstance);
        ProcessInstance callingInstance = this.runtimeService.startProcessInstanceByKey("parentProcess");
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(callingInstance.getId()).singleResult();
        this.runtimeService.createProcessInstanceModification(calledInstance.getId()).cancelAllForActivity("childUserTask").execute();
        ProcessInstance calledInstanceAfterModification = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(calledInstance.getId()).singleResult();
        Assert.assertNull((Object)calledInstanceAfterModification);
        ExecutionTree executionTree = ExecutionTree.forExecution(callingInstance.getId(), this.rule.getProcessEngine());
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("parentUserTask").scope().done());
    }

    private List<String> collectIds(List<ProcessInstance> processInstances) {
        ArrayList<String> supbrocessIds = new ArrayList<String>();
        for (ProcessInstance processInstance : processInstances) {
            supbrocessIds.add(processInstance.getId());
        }
        return supbrocessIds;
    }
}

