/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.persistence.entity.DelayedVariableEvent;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class OnlyDispatchVariableEventOnExistingConditionsTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();

    @Test
    public void testProcessWithIntermediateConditionalEvent() {
        BpmnModelInstance modelInstance = ((ConditionalEventDefinitionBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().serviceTask().camundaClass(CheckDelayedVariablesDelegate.class.getName())).intermediateCatchEvent().conditionalEventDefinition().condition("${var==1}")).conditionalEventDefinitionDone().endEvent().done();
        this.rule.manageDeployment(this.rule.getRepositoryService().createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstanceWithVariablesImpl processInstance = (ProcessInstanceWithVariablesImpl)this.rule.getRuntimeService().startProcessInstanceByKey("conditionalEventProcess");
        Object property = processInstance.getExecutionEntity().getProcessDefinition().getProperty("hasConditionalEvents");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)property);
    }

    @Test
    public void testProcessWithBoundaryConditionalEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().serviceTask().camundaClass(CheckDelayedVariablesDelegate.class.getName())).userTask("taskWithCondition").endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)ModifiableBpmnModelInstance.modify(modelInstance).userTaskBuilder("taskWithCondition").boundaryEvent().conditionalEventDefinition().condition("${var==1}")).conditionalEventDefinitionDone().endEvent().done();
        this.rule.manageDeployment(this.rule.getRepositoryService().createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstanceWithVariablesImpl processInstance = (ProcessInstanceWithVariablesImpl)this.rule.getRuntimeService().startProcessInstanceByKey("conditionalEventProcess");
        Object property = processInstance.getExecutionEntity().getProcessDefinition().getProperty("hasConditionalEvents");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)property);
    }

    @Test
    public void testProcessWithEventSubProcessConditionalEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().serviceTask().camundaClass(CheckDelayedVariablesDelegate.class.getName())).userTask().endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().conditionalEventDefinition().condition("${var==1}")).conditionalEventDefinitionDone().endEvent().done();
        this.rule.manageDeployment(this.rule.getRepositoryService().createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstanceWithVariablesImpl processInstance = (ProcessInstanceWithVariablesImpl)this.rule.getRuntimeService().startProcessInstanceByKey("conditionalEventProcess");
        Object property = processInstance.getExecutionEntity().getProcessDefinition().getProperty("hasConditionalEvents");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)property);
    }

    @Test
    public void testProcessWithoutConditionalEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().serviceTask().camundaClass(CheckNoDelayedVariablesDelegate.class.getName())).userTask().endEvent().done();
        this.rule.manageDeployment(this.rule.getRepositoryService().createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstanceWithVariablesImpl processInstance = (ProcessInstanceWithVariablesImpl)this.rule.getRuntimeService().startProcessInstanceByKey("conditionalEventProcess");
        Object property = processInstance.getExecutionEntity().getProcessDefinition().getProperty("hasConditionalEvents");
        Assert.assertNull((Object)property);
    }

    public static class CheckNoDelayedVariablesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("v", (Object)1);
            List delayedEvents = ((ExecutionEntity)execution).getDelayedEvents();
            Assert.assertEquals((long)0L, (long)delayedEvents.size());
        }
    }

    public static class CheckDelayedVariablesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("v", (Object)1);
            List delayedEvents = ((ExecutionEntity)execution).getDelayedEvents();
            Assert.assertEquals((long)1L, (long)delayedEvents.size());
            Assert.assertEquals((Object)"v", (Object)((DelayedVariableEvent)delayedEvents.get(0)).getEvent().getVariableInstance().getName());
        }
    }
}

