/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.test.bpmn.event.signal.DummyServiceTask;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SignalEventTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testSignalCatchIntermediate() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundary.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testSignalCatchBoundary() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundaryWithReceiveTask.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testSignalCatchBoundaryWithVariables() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("processName", "catchSignal");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("catchSignal", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("processName", "throwSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal", variables2);
        Assert.assertEquals((Object)"catchSignal", (Object)this.runtimeService.getVariable(pi.getId(), "processName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsynch.bpmn20.xml"})
    @Test
    public void testSignalCatchIntermediateAsynch() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        try {
            ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
            this.testRule.waitForJobExecutorToProcessAllJobs(10000L);
            Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
            Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchMultipleSignals.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAbortSignal.bpmn20.xml"})
    @Test
    public void testSignalCatchDifferentSignals() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)2L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwAbort");
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Task taskAfterAbort = (Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult();
        Assert.assertNotNull((Object)taskAfterAbort);
        this.taskService.complete(taskAfterAbort.getId());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testSignalBoundaryOnSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("signalEventOnSubprocess");
        this.runtimeService.signalEventReceived("stopSignal");
        this.testRule.assertProcessEnded(pi.getProcessInstanceId());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    @Test
    public void testNonInterruptingSignal() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalEvent");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        Assert.assertEquals((Object)"My User Task", (Object)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("My User Task") || task.getName().equals("My Second User Task")) continue;
            Assert.fail((String)("Expected: <My User Task> or <My Second User Task> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("My User Task").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        currentTask = (Task)tasks.get(0);
        Assert.assertEquals((Object)"My Second User Task", (Object)currentTask.getName());
    }

    @Deployment
    @Test
    public void testNonInterruptingSignalWithSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalWithSubProcess");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Approve", (Object)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("Approve") || task.getName().equals("Review")) continue;
            Assert.fail((String)("Expected: <Approve> or <Review> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Approve").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        currentTask = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Review", (Object)currentTask.getName());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Review").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Deployment
    @Test
    public void testSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
    }

    @Deployment
    @Test
    public void testNonInterruptingSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml"})
    @Test
    public void testSignalStartEvent() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml"})
    @Test
    public void testSuspendedProcessWithSignalStartEvent() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.testOtherSignalStartEvent.bpmn20.xml"})
    @Test
    public void testMultipleProcessesWithSameSignalStartEvent() {
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceBySignalFromIntermediateThrowingSignalEvent() {
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testIntermediateThrowingSignalEventWithSuspendedSignalStartEvent() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testProcessesWithMultipleSignalStartEvents() {
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertTwiceAndTerminate.bpmn20.xml"})
    @Test
    public void testThrowSignalMultipleCancellingReceivers() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("catchAlertTwiceAndTerminate");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertTwiceAndTerminate.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testIntermediateThrowSignalMultipleCancellingReceivers() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("catchAlertTwiceAndTerminate");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml"})
    @Test
    public void testAsyncSignalStartEventJobProperties() {
        ProcessDefinition catchingProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((Object)catchingProcessDefinition.getId(), (Object)asyncJob.getProcessDefinitionId());
        Assert.assertEquals((Object)catchingProcessDefinition.getKey(), (Object)asyncJob.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncJob.getExceptionMessage());
        Assert.assertNull((Object)asyncJob.getExecutionId());
        Assert.assertNull((Object)asyncJob.getJobDefinitionId());
        Assert.assertEquals((long)0L, (long)asyncJob.getPriority());
        Assert.assertNull((Object)asyncJob.getProcessInstanceId());
        Assert.assertEquals((long)3L, (long)asyncJob.getRetries());
        Assert.assertNull((Object)asyncJob.getDuedate());
        Assert.assertNull((Object)asyncJob.getDeploymentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml"})
    @Test
    public void testAsyncSignalStartEvent() {
        ProcessDefinition catchingProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)catchingProcessDefinition.getId(), (Object)processInstance.getProcessDefinitionId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    @Ignore
    public void FAILING_testNoContinuationWhenSignalInterruptsThrowingActivity() {
        this.runtimeService.startProcessInstanceByKey("signalEventSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(subProcessTask.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterSubProcessTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml"})
    @Test
    public void testSetSerializedVariableValues() throws IOException, ClassNotFoundException {
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.signalEventReceived("alert", (Map)Variables.createVariables().putValueTyped("var", Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()));
        ProcessInstance startedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)startedInstance);
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(startedInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundary.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml"})
    @Test
    @Ignore
    public void FAILING_testAsyncSignalBoundary() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }
}

