/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskListenerDelegateCompletionTest {
    protected static final String COMPLETE_LISTENER = "org.camunda.bpm.engine.test.bpmn.tasklistener.util.CompletingTaskListener";
    protected static final String TASK_LISTENER_PROCESS = "taskListenerProcess";
    protected static final String ACTIVITY_ID = "UT";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void setUp() {
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @After
    public void cleanUp() {
        if (this.runtimeService.createProcessInstanceQuery().count() > 0L) {
            this.runtimeService.deleteProcessInstance(((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId(), null, true);
        }
    }

    protected static BpmnModelInstance setupProcess(String eventName) {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)TASK_LISTENER_PROCESS).startEvent().userTask(ACTIVITY_ID).camundaTaskListenerClass(eventName, COMPLETE_LISTENER)).endEvent().done();
    }

    @Test
    public void testCompletionIsPossibleOnCreation() {
        this.createProcessWithListener("create");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testCompletionIsPossibleOnAssignment() {
        this.createProcessWithListener("assignment");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "test assignee");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testCompletionIsNotPossibleOnComplete() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"invalid task state"));
        this.createProcessWithListener("complete");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    @Test
    public void testCompletionIsNotPossibleOnDelete() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"invalid task state"));
        this.createProcessWithListener("delete");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test reason");
    }

    protected void createProcessWithListener(String eventName) {
        BpmnModelInstance bpmnModelInstance = TaskListenerDelegateCompletionTest.setupProcess(eventName);
        this.testHelper.deploy(bpmnModelInstance);
    }
}

