/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.history.handler.CompositeDbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.AbstractCompositeHistoryEventHandlerTest;

public class CompositeDbHistoryEventHandlerTest
extends AbstractCompositeHistoryEventHandlerTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerNonArgumentConstructor() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new CompositeDbHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)0, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeDbHistoryEventHandlerNonArgumentConstructorAddNullEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        try {
            compositeDbHistoryEventHandler.add(null);
            CompositeDbHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerNonArgumentConstructorAddNotNullEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerNonArgumentConstructorAddTwoNotNullEvents() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)4, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNullVarargs() {
        Object historyEventHandler = null;
        try {
            new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{historyEventHandler});
            CompositeDbHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNullTwoVarargs() {
        try {
            new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{null, null});
            CompositeDbHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNotNullVarargsOneEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)2, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNotNullVarargsTwoEvents() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler(), new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)4, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithEmptyList() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new ArrayList());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)0, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNotEmptyListNullTwoEvents() {
        ArrayList<Object> historyEventHandlers = new ArrayList<Object>();
        historyEventHandlers.add(null);
        historyEventHandlers.add(null);
        try {
            new CompositeDbHistoryEventHandler(historyEventHandlers);
            CompositeDbHistoryEventHandlerTest.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("History event handler is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testCompositeDbHistoryEventHandlerArgumentConstructorWithNotEmptyListNotNullTwoEvents() {
        ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler> historyEventHandlers = new ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler>();
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(historyEventHandlers);
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        CompositeDbHistoryEventHandlerTest.assertEquals((int)4, (int)this.countCustomHistoryEventHandler);
        CompositeDbHistoryEventHandlerTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }
}

