/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricTaskInstanceReportResult;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricTaskReportTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected HistoryService historyService;
    protected static final String PROCESS_DEFINITION_KEY = "HISTORIC_TASK_INST_REPORT";
    protected static final String ANOTHER_PROCESS_DEFINITION_KEY = "ANOTHER_HISTORIC_TASK_INST_REPORT";

    @Before
    public void setUp() {
        this.historyService = this.processEngineRule.getHistoryService();
        this.processEngineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(ANOTHER_PROCESS_DEFINITION_KEY));
    }

    @After
    public void cleanUp() {
        List list = this.processEngineRule.getTaskService().createTaskQuery().list();
        for (Task task : list) {
            this.processEngineRule.getTaskService().deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testHistoricTaskInstanceReportQuery() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().countByTaskName();
        Assert.assertEquals((long)2L, (long)historicTaskInstanceReportResults.size());
        Assert.assertEquals((float)2.0f, (float)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getCount().longValue(), (float)0.0f);
        Assert.assertEquals((Object)ANOTHER_PROCESS_DEFINITION_KEY, (Object)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getProcessDefinitionKey());
        Assert.assertEquals((Object)"name_ANOTHER_HISTORIC_TASK_INST_REPORT", (Object)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getProcessDefinitionName());
        Assert.assertEquals((Object)"ANOTHER_HISTORIC_TASK_INST_REPORT Task 1", (Object)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getTaskName());
        Assert.assertTrue((boolean)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(1)).getProcessDefinitionId().contains(":2:"));
    }

    @Test
    public void testHistoricTaskInstanceReportGroupedByProcessDefinitionKey() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().countByProcessDefinitionKey();
        Assert.assertEquals((long)2L, (long)historicTaskInstanceReportResults.size());
        Assert.assertTrue((boolean)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getProcessDefinitionId().contains(":1:"));
        Assert.assertEquals((Object)"name_ANOTHER_HISTORIC_TASK_INST_REPORT", (Object)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getProcessDefinitionName());
        Assert.assertEquals((Object)ANOTHER_PROCESS_DEFINITION_KEY, (Object)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getProcessDefinitionKey());
    }

    @Test
    public void testHistoricTaskInstanceReportWithCompletedAfterDate() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 8, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().completedAfter(calendar.getTime()).countByProcessDefinitionKey();
        Assert.assertEquals((long)1L, (long)historicTaskInstanceReportResults.size());
        Assert.assertEquals((float)1.0f, (float)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getCount().longValue(), (float)0.0f);
    }

    @Test
    public void testHistoricTaskInstanceReportWithCompletedBeforeDate() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 8, 14, 12, 1);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().completedBefore(calendar.getTime()).countByProcessDefinitionKey();
        Assert.assertEquals((long)2L, (long)historicTaskInstanceReportResults.size());
        Assert.assertEquals((float)1.0f, (float)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getCount().longValue(), (float)0.0f);
    }

    @Test
    public void testCompletedAfterWithNullValue() {
        try {
            this.historyService.createHistoricTaskInstanceReport().completedAfter(null).countByProcessDefinitionKey();
            Assert.fail((String)"Expected NotValidException");
        }
        catch (NotValidException nve) {
            Assert.assertTrue((boolean)nve.getMessage().contains("completedAfter"));
        }
    }

    @Test
    public void testCompletedBeforeWithNullValue() {
        try {
            this.historyService.createHistoricTaskInstanceReport().completedBefore(null).countByProcessDefinitionKey();
            Assert.fail((String)"Expected NotValidException");
        }
        catch (NotValidException nve) {
            Assert.assertTrue((boolean)nve.getMessage().contains("completedBefore"));
        }
    }

    @Test
    public void testReportWithNullTaskName() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        BpmnModelInstance instance = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)ANOTHER_PROCESS_DEFINITION_KEY).name("name_ANOTHER_HISTORIC_TASK_INST_REPORT")).startEvent().userTask("task1_ANOTHER_HISTORIC_TASK_INST_REPORT").name(null)).endEvent().done();
        this.processEngineTestRule.deploy(instance);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().completedBefore(calendar.getTime()).countByTaskName();
        Assert.assertEquals((long)1L, (long)historicTaskInstanceReportResults.size());
        Assert.assertEquals((float)1.0f, (float)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getCount().longValue(), (float)0.0f);
    }

    @Test
    public void testReportWithEmptyTaskName() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        BpmnModelInstance instance = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)ANOTHER_PROCESS_DEFINITION_KEY).name("name_ANOTHER_HISTORIC_TASK_INST_REPORT")).startEvent().userTask("task1_ANOTHER_HISTORIC_TASK_INST_REPORT").name("")).endEvent().done();
        this.processEngineTestRule.deploy(instance);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 12, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List historicTaskInstanceReportResults = this.historyService.createHistoricTaskInstanceReport().completedBefore(calendar.getTime()).countByTaskName();
        Assert.assertEquals((long)1L, (long)historicTaskInstanceReportResults.size());
        Assert.assertEquals((float)1.0f, (float)((HistoricTaskInstanceReportResult)historicTaskInstanceReportResults.get(0)).getCount().longValue(), (float)0.0f);
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        double random = Math.random();
        return ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)key).name("name_" + key)).startEvent().userTask(key + "_" + random + "_task1").name(key + " Task 1")).endEvent().done();
    }

    protected void completeTask(String pid) {
        Task task = (Task)this.processEngineRule.getTaskService().createTaskQuery().processInstanceId(pid).singleResult();
        this.processEngineRule.getTaskService().complete(task.getId());
    }

    protected void setCurrentTime(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, dayOfMonth, hourOfDay, minute);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
    }

    protected void addToCalendar(int field, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ClockUtil.getCurrentTime());
        calendar.add(field, month);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
    }

    protected void startAndCompleteProcessInstance(String key, int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this.setCurrentTime(year, month, dayOfMonth, hourOfDay, minute);
        ProcessInstance pi = this.processEngineRule.getRuntimeService().startProcessInstanceByKey(key);
        this.addToCalendar(2, 5);
        this.completeTask(pi.getId());
        ClockUtil.reset();
    }
}

