/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl.variable.mapper.primitive;

import org.camunda.bpm.client.impl.variable.mapper.ValueMapper;
import org.camunda.bpm.client.task.impl.dto.TypedValueDto;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class PrimitiveValueMapper<T extends TypedValue>
implements ValueMapper<T> {
    protected PrimitiveValueType type;

    protected PrimitiveValueMapper(PrimitiveValueType type) {
        this.type = type;
    }

    @Override
    public String getTypeName() {
        return this.type.getName();
    }

    public boolean isAssignable(TypedValue typedValue) {
        if (typedValue == null || typedValue.getValue() == null) {
            return false;
        }
        Object value = typedValue.getValue();
        return this.isAssignable(value);
    }

    protected boolean isAssignable(Object value) {
        return this.type.getJavaType().isAssignableFrom(value.getClass());
    }

    public T convertToTypedValue(UntypedValueImpl untypedValue) {
        return (T)this.type.createValue(untypedValue.getValue(), null);
    }

    @Override
    public T deserializeTypedValue(TypedValueDto typedValueDto) {
        Object value = typedValueDto.getValue();
        if (this.isAssignable(value)) {
            return (T)this.type.createValue(value, typedValueDto.getValueInfo());
        }
        return null;
    }
}

