/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl.variable.mapper.serializable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.variable.mapper.ValueMapper;
import org.camunda.bpm.client.task.impl.dto.TypedValueDto;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class ObjectValueMapper
implements ValueMapper<ObjectValue> {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected static final String OBJECT_TYPE_NAME = "objectTypeName";
    protected static final String SERIALIZATION_DATA_FORMAT = "serializationDataFormat";
    protected static final String TRANSIENT = "transient";
    protected ObjectMapper objectMapper;

    public ObjectValueMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getTypeName() {
        return ValueType.OBJECT.getName();
    }

    @Override
    public ObjectValue deserializeTypedValue(TypedValueDto typedValueDto) {
        Boolean isTransient;
        String serializationDataFormat;
        String serializedValue = (String)typedValueDto.getValue();
        Class<?> type = null;
        try {
            type = Class.forName((String)typedValueDto.getValueInfo().get(OBJECT_TYPE_NAME));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Object object = null;
        try {
            object = this.objectMapper.readValue(serializedValue, type);
        }
        catch (IOException e) {
            return null;
        }
        ObjectValueImpl objectValue = new ObjectValueImpl(object);
        objectValue.setSerializedValue(serializedValue);
        Map<String, Object> valueInfo = typedValueDto.getValueInfo();
        String objectTypeName = (String)valueInfo.get(OBJECT_TYPE_NAME);
        if (objectTypeName != null) {
            objectValue.setObjectTypeName(objectTypeName);
        }
        if ((serializationDataFormat = (String)valueInfo.get(SERIALIZATION_DATA_FORMAT)) != null) {
            objectValue.setSerializationDataFormat(serializationDataFormat);
        }
        if ((isTransient = (Boolean)valueInfo.get(TRANSIENT)) != null) {
            objectValue.setTransient(isTransient.booleanValue());
        }
        return objectValue;
    }

    @Override
    public TypedValueDto serializeTypedValue(TypedValue typedValue) {
        ObjectValue objectValue = (ObjectValue)typedValue;
        TypedValueDto typedValueDto = ValueMapper.super.serializeTypedValue(typedValue);
        Map<String, Object> valueInfo = typedValueDto.getValueInfo();
        valueInfo.put(OBJECT_TYPE_NAME, objectValue.getValue().getClass());
        typedValueDto.setValueInfo(valueInfo);
        typedValueDto.setValue(objectValue.getValueSerialized());
        return typedValueDto;
    }

    public ObjectValue convertToObjectValue(ObjectValue objectValue) {
        ObjectValueImpl serializedObjectValue = (ObjectValueImpl)objectValue;
        Object object = objectValue.getValue();
        String serializedObject = null;
        try {
            serializedObject = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw LOG.unsupportedTypeException(objectValue);
        }
        serializedObjectValue.setSerializedValue(serializedObject);
        serializedObjectValue.setObjectTypeName(object.getClass().getName());
        serializedObjectValue.setSerializationDataFormat(Variables.SerializationDataFormats.JSON.getName());
        serializedObjectValue.setTransient(objectValue.isTransient());
        return serializedObjectValue;
    }
}

