/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.List;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.topic.TopicSubscription;
import org.camunda.bpm.client.topic.TopicSubscriptionBuilder;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManager;

public class TopicSubscriptionBuilderImpl
implements TopicSubscriptionBuilder {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String topicName;
    protected long lockDuration;
    protected ExternalTaskHandler externalTaskHandler;
    protected TopicSubscriptionManager topicSubscriptionManager;

    public TopicSubscriptionBuilderImpl(String topicName, TopicSubscriptionManager topicSubscriptionManager) {
        this.topicName = topicName;
        this.topicSubscriptionManager = topicSubscriptionManager;
    }

    @Override
    public TopicSubscriptionBuilder lockDuration(long lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder handler(ExternalTaskHandler externalTaskHandler) {
        this.externalTaskHandler = externalTaskHandler;
        return this;
    }

    @Override
    public TopicSubscription open() {
        if (this.topicName == null) {
            throw LOG.topicNameNullException();
        }
        if (this.lockDuration <= 0L) {
            throw LOG.lockDurationIsNotGreaterThanZeroException();
        }
        if (this.externalTaskHandler == null) {
            throw LOG.externalTaskHandlerNullException();
        }
        this.checkTopicNameAlreadySubscribed();
        TopicSubscriptionImpl subscription = new TopicSubscriptionImpl(this.topicName, this.lockDuration, this.externalTaskHandler, this.topicSubscriptionManager);
        this.topicSubscriptionManager.subscribe(subscription);
        return subscription;
    }

    protected void checkTopicNameAlreadySubscribed() {
        List<TopicSubscription> subscriptions = this.topicSubscriptionManager.getSubscriptions();
        subscriptions.forEach(subscription -> {
            if (subscription.getTopicName().equals(this.topicName)) {
                throw LOG.topicNameAlreadySubscribedException();
            }
        });
    }
}

