/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.variable.VariableMappers;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.impl.ExternalTaskImpl;
import org.camunda.bpm.client.task.impl.ExternalTaskServiceImpl;
import org.camunda.bpm.client.task.impl.dto.TypedValueDto;
import org.camunda.bpm.client.topic.TopicSubscription;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManagerLogger;
import org.camunda.bpm.client.topic.impl.dto.TopicRequestDto;
import org.camunda.bpm.engine.variable.VariableMap;

public class TopicSubscriptionManager
implements Runnable {
    protected static final TopicSubscriptionManagerLogger LOG = ExternalTaskClientLogger.TOPIC_SUBSCRIPTION_MANAGER_LOGGER;
    protected EngineClient engineClient;
    protected List<TopicSubscription> subscriptions;
    protected boolean isRunning;
    protected Thread thread;
    protected VariableMappers variableMappers;

    public TopicSubscriptionManager(EngineClient engineClient, VariableMappers variableMappers) {
        this.engineClient = engineClient;
        this.subscriptions = new CopyOnWriteArrayList<TopicSubscription>();
        this.isRunning = true;
        this.thread = new Thread((Runnable)this, TopicSubscriptionManager.class.getSimpleName());
        this.thread.start();
        this.variableMappers = variableMappers;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.acquire();
        }
    }

    protected void acquire() {
        ArrayList<TopicRequestDto> taskTopicRequests = new ArrayList<TopicRequestDto>();
        HashMap externalTaskHandlers = new HashMap();
        this.subscriptions.forEach(subscription -> {
            TopicRequestDto taskTopicRequest = TopicRequestDto.fromTopicSubscription(subscription);
            taskTopicRequests.add(taskTopicRequest);
            String topicName = subscription.getTopicName();
            ExternalTaskHandler externalTaskHandler = subscription.getExternalTaskHandler();
            externalTaskHandlers.put(topicName, externalTaskHandler);
        });
        if (!taskTopicRequests.isEmpty()) {
            List<Object> externalTasks = Collections.emptyList();
            try {
                externalTasks = this.engineClient.fetchAndLock(taskTopicRequests);
            }
            catch (EngineClientException e) {
                LOG.exceptionWhilePerformingFetchAndLock(e);
            }
            externalTasks.forEach(externalTask -> {
                Map<String, TypedValueDto> variableDtoMap = ((ExternalTaskImpl)externalTask).getVariables();
                VariableMap variableMap = null;
                boolean variablesDeserialized = false;
                try {
                    variableMap = this.variableMappers.deserializeVariables(variableDtoMap);
                    variablesDeserialized = true;
                }
                catch (Throwable e) {
                    LOG.exceptionWhileDeserializingVariables(e);
                }
                if (variablesDeserialized) {
                    ((ExternalTaskImpl)externalTask).setVariableMappers(this.variableMappers);
                    ((ExternalTaskImpl)externalTask).setLocalVariableMap(variableMap);
                    String topicName = externalTask.getTopicName();
                    ExternalTaskHandler taskHandler = (ExternalTaskHandler)externalTaskHandlers.get(topicName);
                    ExternalTaskServiceImpl service = new ExternalTaskServiceImpl(externalTask.getId(), this.engineClient);
                    try {
                        taskHandler.execute((ExternalTask)externalTask, service);
                    }
                    catch (ExternalTaskClientException e) {
                        LOG.exceptionOnExternalTaskServiceMethodInvocation(e);
                    }
                    catch (Throwable e) {
                        LOG.exceptionWhileExecutingExternalTaskHandler(e);
                    }
                }
            });
        }
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.exceptionWhileShuttingDown(e);
        }
    }

    protected void subscribe(TopicSubscriptionImpl subscription) {
        this.subscriptions.add(subscription);
    }

    protected void unsubscribe(TopicSubscriptionImpl subscription) {
        this.subscriptions.remove(subscription);
    }

    public EngineClient getEngineClient() {
        return this.engineClient;
    }

    public List<TopicSubscription> getSubscriptions() {
        return this.subscriptions;
    }
}

