/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.camunda.bpm.client.ClientBackoffStrategy;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.ExternalTaskClientBuilder;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.ExternalTaskClientImpl;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.RequestExecutor;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;
import org.camunda.bpm.client.interceptor.impl.RequestInterceptorHandler;
import org.camunda.bpm.client.spi.DataFormat;
import org.camunda.bpm.client.spi.DataFormatConfigurator;
import org.camunda.bpm.client.spi.DataFormatProvider;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManager;
import org.camunda.bpm.client.variable.impl.DefaultValueMappers;
import org.camunda.bpm.client.variable.impl.TypedValues;
import org.camunda.bpm.client.variable.impl.ValueMappers;
import org.camunda.bpm.client.variable.impl.mapper.BooleanValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.ByteArrayValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.DateValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.DoubleValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.IntegerValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.JsonValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.LongValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.NullValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.ObjectValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.ShortValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.StringValueMapper;
import org.camunda.bpm.client.variable.impl.mapper.XmlValueMapper;
import org.camunda.bpm.engine.variable.Variables;

public class ExternalTaskClientBuilderImpl
implements ExternalTaskClientBuilder {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String baseUrl;
    protected String workerId;
    protected int maxTasks = 10;
    protected Long asyncResponseTimeout = null;
    protected long lockDuration = 20000L;
    protected String defaultSerializationFormat = Variables.SerializationDataFormats.JSON.getName();
    protected String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected ObjectMapper objectMapper;
    protected ValueMappers valueMappers;
    protected TypedValues typedValues;
    protected EngineClient engineClient;
    protected TopicSubscriptionManager topicSubscriptionManager;
    protected List<ClientRequestInterceptor> interceptors = new ArrayList<ClientRequestInterceptor>();
    protected boolean isAutoFetchingEnabled = true;
    protected ClientBackoffStrategy backoffStrategy = null;

    @Override
    public ExternalTaskClientBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder addInterceptor(ClientRequestInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public ExternalTaskClientBuilder maxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder asyncResponseTimeout(long asyncResponseTimeout) {
        this.asyncResponseTimeout = asyncResponseTimeout;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder lockDuration(long lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder disableAutoFetching() {
        this.isAutoFetchingEnabled = false;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder backoffStrategy(ClientBackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder defaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Override
    public ExternalTaskClient build() {
        if (this.maxTasks <= 0) {
            throw LOG.maxTasksNotGreaterThanZeroException(this.maxTasks);
        }
        if (this.asyncResponseTimeout != null && this.asyncResponseTimeout <= 0L) {
            throw LOG.asyncResponseTimeoutNotGreaterThanZeroException(this.asyncResponseTimeout);
        }
        if (this.lockDuration <= 0L) {
            throw LOG.lockDurationIsNotGreaterThanZeroException(this.lockDuration);
        }
        if (this.baseUrl == null || this.baseUrl.isEmpty()) {
            throw LOG.baseUrlNullException();
        }
        this.checkInterceptors();
        this.initBaseUrl();
        this.initWorkerId();
        this.initObjectMapper();
        this.initVariableMappers();
        this.initEngineClient();
        this.initTopicSubscriptionManager();
        return new ExternalTaskClientImpl(this.topicSubscriptionManager);
    }

    protected void initBaseUrl() {
        this.baseUrl = this.sanitizeUrl(this.baseUrl);
    }

    protected String sanitizeUrl(String url) {
        if ((url = url.trim()).endsWith("/")) {
            url = url.replaceAll("/$", "");
            url = this.sanitizeUrl(url);
        }
        return url;
    }

    protected void initWorkerId() {
        if (this.workerId == null) {
            String hostname = this.checkHostname();
            this.workerId = hostname + UUID.randomUUID();
        }
    }

    protected void checkInterceptors() {
        this.interceptors.forEach(interceptor -> {
            if (interceptor == null) {
                throw LOG.interceptorNullException();
            }
        });
    }

    protected void initObjectMapper() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        this.objectMapper.setDateFormat((DateFormat)sdf);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    protected void initVariableMappers() {
        this.valueMappers = new DefaultValueMappers(this.defaultSerializationFormat);
        this.valueMappers.addMapper(new NullValueMapper());
        this.valueMappers.addMapper(new BooleanValueMapper());
        this.valueMappers.addMapper(new StringValueMapper());
        this.valueMappers.addMapper(new DateValueMapper(this.dateFormat));
        this.valueMappers.addMapper(new ByteArrayValueMapper());
        this.valueMappers.addMapper(new IntegerValueMapper());
        this.valueMappers.addMapper(new LongValueMapper());
        this.valueMappers.addMapper(new ShortValueMapper());
        this.valueMappers.addMapper(new DoubleValueMapper());
        Map<String, DataFormat> dataFormats = this.lookupDataFormats();
        dataFormats.forEach((key, format) -> this.valueMappers.addMapper(new ObjectValueMapper((String)key, (DataFormat)format)));
        this.valueMappers.addMapper(new JsonValueMapper());
        this.valueMappers.addMapper(new XmlValueMapper());
        this.typedValues = new TypedValues(this.valueMappers);
    }

    protected void initEngineClient() {
        RequestInterceptorHandler requestInterceptorHandler = new RequestInterceptorHandler(this.interceptors);
        RequestExecutor requestExecutor = new RequestExecutor(requestInterceptorHandler, this.objectMapper);
        this.engineClient = new EngineClient(this.workerId, this.maxTasks, this.asyncResponseTimeout, this.baseUrl, requestExecutor, this.typedValues);
    }

    protected void initTopicSubscriptionManager() {
        this.topicSubscriptionManager = new TopicSubscriptionManager(this.engineClient, this.typedValues, this.lockDuration);
        this.topicSubscriptionManager.setBackoffStrategy(this.getBackoffStrategy());
        if (this.isAutoFetchingEnabled()) {
            this.topicSubscriptionManager.start();
        }
    }

    protected Map<String, DataFormat> lookupDataFormats() {
        HashMap<String, DataFormat> dataFormats = new HashMap<String, DataFormat>();
        this.lookupCustomDataFormats(dataFormats);
        this.applyConfigurators(dataFormats);
        return dataFormats;
    }

    protected void lookupCustomDataFormats(Map<String, DataFormat> dataFormats) {
        ServiceLoader<DataFormatProvider> providerLoader = ServiceLoader.load(DataFormatProvider.class);
        for (DataFormatProvider provider : providerLoader) {
            LOG.logDataFormatProvider(provider);
            this.lookupProvider(dataFormats, provider);
        }
    }

    protected void lookupProvider(Map<String, DataFormat> dataFormats, DataFormatProvider provider) {
        String dataFormatName = provider.getDataFormatName();
        if (dataFormats.containsKey(dataFormatName)) {
            throw LOG.multipleProvidersForDataformat(dataFormatName);
        }
        DataFormat dataFormatInstance = provider.createInstance();
        dataFormats.put(dataFormatName, dataFormatInstance);
        LOG.logDataFormat(dataFormatInstance);
    }

    protected void applyConfigurators(Map<String, DataFormat> dataFormats) {
        ServiceLoader<DataFormatConfigurator> configuratorLoader = ServiceLoader.load(DataFormatConfigurator.class);
        for (DataFormatConfigurator configurator : configuratorLoader) {
            LOG.logDataFormatConfigurator(configurator);
            this.applyConfigurator(dataFormats, configurator);
        }
    }

    protected void applyConfigurator(Map<String, DataFormat> dataFormats, DataFormatConfigurator configurator) {
        for (DataFormat dataFormat : dataFormats.values()) {
            if (!configurator.getDataFormatClass().isAssignableFrom(dataFormat.getClass())) continue;
            configurator.configure(dataFormat);
        }
    }

    public String checkHostname() {
        String hostname;
        try {
            hostname = this.getHostname();
        }
        catch (UnknownHostException e) {
            throw LOG.cannotGetHostnameException(e);
        }
        return hostname;
    }

    public String getHostname() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected String getWorkerId() {
        return this.workerId;
    }

    protected List<ClientRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected int getMaxTasks() {
        return this.maxTasks;
    }

    protected Long getAsyncResponseTimeout() {
        return this.asyncResponseTimeout;
    }

    protected long getLockDuration() {
        return this.lockDuration;
    }

    protected boolean isAutoFetchingEnabled() {
        return this.isAutoFetchingEnabled;
    }

    protected ClientBackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ValueMappers getValueMappers() {
        return this.valueMappers;
    }

    public TypedValues getTypedValues() {
        return this.typedValues;
    }

    public EngineClient getEngineClient() {
        return this.engineClient;
    }
}

